// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a gateway object.
 */
public class GatewayInfo private constructor(builder: Builder) {
    /**
     * The ID of the Amazon EC2 instance that was used to launch the gateway.
     */
    public val ec2InstanceId: kotlin.String? = builder.ec2InstanceId
    /**
     * The Amazon Web Services Region where the Amazon EC2 instance is located.
     */
    public val ec2InstanceRegion: kotlin.String? = builder.ec2InstanceRegion
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.
     */
    public val gatewayId: kotlin.String? = builder.gatewayId
    /**
     * The name of the gateway.
     */
    public val gatewayName: kotlin.String? = builder.gatewayName
    /**
     * The state of the gateway.
     *
     * Valid Values: `DISABLED` | `ACTIVE`
     */
    public val gatewayOperationalState: kotlin.String? = builder.gatewayOperationalState
    /**
     * The type of the gateway.
     */
    public val gatewayType: kotlin.String? = builder.gatewayType
    /**
     * The type of hardware or software platform on which the gateway is running.
     */
    public val hostEnvironment: aws.sdk.kotlin.services.storagegateway.model.HostEnvironment? = builder.hostEnvironment
    /**
     * A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.
     */
    public val hostEnvironmentId: kotlin.String? = builder.hostEnvironmentId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.GatewayInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatewayInfo(")
        append("ec2InstanceId=$ec2InstanceId,")
        append("ec2InstanceRegion=$ec2InstanceRegion,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayId=$gatewayId,")
        append("gatewayName=$gatewayName,")
        append("gatewayOperationalState=$gatewayOperationalState,")
        append("gatewayType=$gatewayType,")
        append("hostEnvironment=$hostEnvironment,")
        append("hostEnvironmentId=$hostEnvironmentId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2InstanceId?.hashCode() ?: 0
        result = 31 * result + (ec2InstanceRegion?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayOperationalState?.hashCode() ?: 0)
        result = 31 * result + (gatewayType?.hashCode() ?: 0)
        result = 31 * result + (hostEnvironment?.hashCode() ?: 0)
        result = 31 * result + (hostEnvironmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatewayInfo

        if (ec2InstanceId != other.ec2InstanceId) return false
        if (ec2InstanceRegion != other.ec2InstanceRegion) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayId != other.gatewayId) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayOperationalState != other.gatewayOperationalState) return false
        if (gatewayType != other.gatewayType) return false
        if (hostEnvironment != other.hostEnvironment) return false
        if (hostEnvironmentId != other.hostEnvironmentId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.GatewayInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon EC2 instance that was used to launch the gateway.
         */
        public var ec2InstanceId: kotlin.String? = null
        /**
         * The Amazon Web Services Region where the Amazon EC2 instance is located.
         */
        public var ec2InstanceRegion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to return a list of gateways for your account and Amazon Web Services Region.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part of the gateway Amazon Resource Name (ARN), which you use as input for other operations.
         */
        public var gatewayId: kotlin.String? = null
        /**
         * The name of the gateway.
         */
        public var gatewayName: kotlin.String? = null
        /**
         * The state of the gateway.
         *
         * Valid Values: `DISABLED` | `ACTIVE`
         */
        public var gatewayOperationalState: kotlin.String? = null
        /**
         * The type of the gateway.
         */
        public var gatewayType: kotlin.String? = null
        /**
         * The type of hardware or software platform on which the gateway is running.
         */
        public var hostEnvironment: aws.sdk.kotlin.services.storagegateway.model.HostEnvironment? = null
        /**
         * A unique identifier for the specific instance of the host platform running the gateway. This value is only available for certain host environments, and its format depends on the host environment type.
         */
        public var hostEnvironmentId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.GatewayInfo) : this() {
            this.ec2InstanceId = x.ec2InstanceId
            this.ec2InstanceRegion = x.ec2InstanceRegion
            this.gatewayArn = x.gatewayArn
            this.gatewayId = x.gatewayId
            this.gatewayName = x.gatewayName
            this.gatewayOperationalState = x.gatewayOperationalState
            this.gatewayType = x.gatewayType
            this.hostEnvironment = x.hostEnvironment
            this.hostEnvironmentId = x.hostEnvironmentId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.GatewayInfo = GatewayInfo(this)
    }
}
