// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * CreateNFSFileShareInput
 */
public class CreateNfsFileShareRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public val auditDestinationArn: kotlin.String? = builder.auditDestinationArn
    /**
     * Specifies the Region of the S3 bucket where the NFS file share stores files.
     *
     * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    public val bucketRegion: kotlin.String? = builder.bucketRegion
    /**
     * Specifies refresh cache information for the file share.
     */
    public val cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = builder.cacheAttributes
    /**
     * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.
     */
    public val clientList: List<String>? = builder.clientList
    /**
     * A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
     *
     * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
     */
    public val defaultStorageClass: kotlin.String? = builder.defaultStorageClass
    /**
     * The name of the file share. Optional.
     *
     * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
     */
    public val fileShareName: kotlin.String? = builder.fileShareName
    /**
     * The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file share.
     */
    public val gatewayArn: kotlin.String? = builder.gatewayArn
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
     *
     * Valid Values: `true` | `false`
     */
    public val guessMimeTypeEnabled: kotlin.Boolean? = builder.guessMimeTypeEnabled
    /**
     * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
     *
     * Valid Values: `true` | `false`
     */
    public val kmsEncrypted: kotlin.Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).
     *
     * You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.
     *
     * Bucket ARN:
     *
     * `arn:aws:s3:::my-bucket/prefix/`
     *
     * Access point ARN:
     *
     * `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
     *
     * If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see [Delegating access control to access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control) in the *Amazon S3 User Guide*.
     *
     * Access point alias:
     *
     * `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
     */
    public val locationArn: kotlin.String? = builder.locationArn
    /**
     * File share default values. Optional.
     */
    public val nfsFileShareDefaults: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults? = builder.nfsFileShareDefaults
    /**
     * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
     *
     * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
     *
     * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
     *
     * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
     *
     * The following example sets `NotificationPolicy` off.
     *
     * `{}`
     */
    public val notificationPolicy: kotlin.String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
     */
    public val objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = builder.objectAcl
    /**
     * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
     *
     * Valid Values: `true` | `false`
     */
    public val readOnly: kotlin.Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
     *
     * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
     *
     * Valid Values: `true` | `false`
     */
    public val requesterPays: kotlin.Boolean? = builder.requesterPays
    /**
     * The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.
     */
    public val role: kotlin.String? = builder.role
    /**
     * A value that maps a user to anonymous user.
     *
     * Valid values are the following:
     * + `RootSquash`: Only root is mapped to anonymous user.
     * + `NoSquash`: No one is mapped to anonymous user.
     * + `AllSquash`: Everyone is mapped to anonymous user.
     */
    public val squash: kotlin.String? = builder.squash
    /**
     * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
     *
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.
     *
     * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
     */
    public val vpcEndpointDnsName: kotlin.String? = builder.vpcEndpointDnsName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.storagegateway.model.CreateNfsFileShareRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNfsFileShareRequest(")
        append("auditDestinationArn=$auditDestinationArn,")
        append("bucketRegion=$bucketRegion,")
        append("cacheAttributes=$cacheAttributes,")
        append("clientList=$clientList,")
        append("clientToken=$clientToken,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("fileShareName=$fileShareName,")
        append("gatewayArn=$gatewayArn,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("locationArn=$locationArn,")
        append("nfsFileShareDefaults=$nfsFileShareDefaults,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("role=$role,")
        append("squash=$squash,")
        append("tags=$tags,")
        append("vpcEndpointDnsName=$vpcEndpointDnsName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auditDestinationArn?.hashCode() ?: 0
        result = 31 * result + (bucketRegion?.hashCode() ?: 0)
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (clientList?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (locationArn?.hashCode() ?: 0)
        result = 31 * result + (nfsFileShareDefaults?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (squash?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointDnsName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNfsFileShareRequest

        if (auditDestinationArn != other.auditDestinationArn) return false
        if (bucketRegion != other.bucketRegion) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (clientList != other.clientList) return false
        if (clientToken != other.clientToken) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (fileShareName != other.fileShareName) return false
        if (gatewayArn != other.gatewayArn) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (locationArn != other.locationArn) return false
        if (nfsFileShareDefaults != other.nfsFileShareDefaults) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (role != other.role) return false
        if (squash != other.squash) return false
        if (tags != other.tags) return false
        if (vpcEndpointDnsName != other.vpcEndpointDnsName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.storagegateway.model.CreateNfsFileShareRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        public var auditDestinationArn: kotlin.String? = null
        /**
         * Specifies the Region of the S3 bucket where the NFS file share stores files.
         *
         * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        public var bucketRegion: kotlin.String? = null
        /**
         * Specifies refresh cache information for the file share.
         */
        public var cacheAttributes: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes? = null
        /**
         * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IP addresses or valid CIDR blocks.
         */
        public var clientList: List<String>? = null
        /**
         * A unique string value that you supply that is used by S3 File Gateway to ensure idempotent file share creation.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
         *
         * Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` | `S3_STANDARD_IA` | `S3_ONEZONE_IA`
         */
        public var defaultStorageClass: kotlin.String? = null
        /**
         * The name of the file share. Optional.
         *
         * `FileShareName` must be set if an S3 prefix name is set in `LocationARN`, or if an access point or access point alias is used.
         */
        public var fileShareName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the S3 File Gateway on which you want to create a file share.
         */
        public var gatewayArn: kotlin.String? = null
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to `true` to enable MIME type guessing, otherwise set to `false`. The default value is `true`.
         *
         * Valid Values: `true` | `false`
         */
        public var guessMimeTypeEnabled: kotlin.Boolean? = null
        /**
         * Set to `true` to use Amazon S3 server-side encryption with your own KMS key, or `false` to use a key managed by Amazon S3. Optional.
         *
         * Valid Values: `true` | `false`
         */
        public var kmsEncrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when `KMSEncrypted` is `true`. Optional.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * A custom ARN for the backend storage used for storing data for file shares. It includes a resource ARN with an optional prefix concatenation. The prefix must end with a forward slash (/).
         *
         * You can specify LocationARN as a bucket ARN, access point ARN or access point alias, as shown in the following examples.
         *
         * Bucket ARN:
         *
         * `arn:aws:s3:::my-bucket/prefix/`
         *
         * Access point ARN:
         *
         * `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
         *
         * If you specify an access point, the bucket policy must be configured to delegate access control to the access point. For information, see [Delegating access control to access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control) in the *Amazon S3 User Guide*.
         *
         * Access point alias:
         *
         * `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
         */
        public var locationArn: kotlin.String? = null
        /**
         * File share default values. Optional.
         */
        public var nfsFileShareDefaults: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults? = null
        /**
         * The notification policy of the file share. `SettlingTimeInSeconds` controls the number of seconds to wait after the last point in time a client wrote to a file before generating an `ObjectUploaded` notification. Because clients can make many small writes to files, it's best to set this parameter for as long as possible to avoid generating multiple notifications for the same file in a small time period.
         *
         * `SettlingTimeInSeconds` has no effect on the timing of the object uploading to Amazon S3, only the timing of the notification.
         *
         * The following example sets `NotificationPolicy` on with `SettlingTimeInSeconds` set to 60.
         *
         * `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
         *
         * The following example sets `NotificationPolicy` off.
         *
         * `{}`
         */
        public var notificationPolicy: kotlin.String? = null
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway puts objects into. The default value is `private`.
         */
        public var objectAcl: aws.sdk.kotlin.services.storagegateway.model.ObjectAcl? = null
        /**
         * A value that sets the write status of a file share. Set this value to `true` to set the write status to read-only, otherwise set to `false`.
         *
         * Valid Values: `true` | `false`
         */
        public var readOnly: kotlin.Boolean? = null
        /**
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket. If this value is set to `true`, the requester pays the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.
         *
         * `RequesterPays` is a configuration for the S3 bucket that backs the file share, so make sure that the configuration on the file share is the same as the S3 bucket configuration.
         *
         * Valid Values: `true` | `false`
         */
        public var requesterPays: kotlin.Boolean? = null
        /**
         * The ARN of the Identity and Access Management (IAM) role that an S3 File Gateway assumes when it accesses the underlying storage.
         */
        public var role: kotlin.String? = null
        /**
         * A value that maps a user to anonymous user.
         *
         * Valid values are the following:
         * + `RootSquash`: Only root is mapped to anonymous user.
         * + `NoSquash`: No one is mapped to anonymous user.
         * + `AllSquash`: Everyone is mapped to anonymous user.
         */
        public var squash: kotlin.String? = null
        /**
         * A list of up to 50 tags that can be assigned to the NFS file share. Each tag is a key-value pair.
         *
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the maximum length for a tag's value is 256.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies the DNS name for the VPC endpoint that the NFS file share uses to connect to Amazon S3.
         *
         * This parameter is required for NFS file shares that connect to Amazon S3 through a VPC endpoint, a VPC access point, or an access point alias that points to a VPC access point.
         */
        public var vpcEndpointDnsName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.storagegateway.model.CreateNfsFileShareRequest) : this() {
            this.auditDestinationArn = x.auditDestinationArn
            this.bucketRegion = x.bucketRegion
            this.cacheAttributes = x.cacheAttributes
            this.clientList = x.clientList
            this.clientToken = x.clientToken
            this.defaultStorageClass = x.defaultStorageClass
            this.fileShareName = x.fileShareName
            this.gatewayArn = x.gatewayArn
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.locationArn = x.locationArn
            this.nfsFileShareDefaults = x.nfsFileShareDefaults
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.role = x.role
            this.squash = x.squash
            this.tags = x.tags
            this.vpcEndpointDnsName = x.vpcEndpointDnsName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.storagegateway.model.CreateNfsFileShareRequest = CreateNfsFileShareRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        public fun cacheAttributes(block: aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.Builder.() -> kotlin.Unit) {
            this.cacheAttributes = aws.sdk.kotlin.services.storagegateway.model.CacheAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults] inside the given [block]
         */
        public fun nfsFileShareDefaults(block: aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults.Builder.() -> kotlin.Unit) {
            this.nfsFileShareDefaults = aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults.invoke(block)
        }
    }
}
