// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.serde

import aws.sdk.kotlin.services.ssooidc.model.SsoOidcException
import aws.sdk.kotlin.services.ssooidc.model.StartDeviceAuthorizationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartDeviceAuthorizationOperationDeserializer: HttpDeserialize<StartDeviceAuthorizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartDeviceAuthorizationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartDeviceAuthorizationError(context, call)
        }
        val builder = StartDeviceAuthorizationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartDeviceAuthorizationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwStartDeviceAuthorizationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsoOidcException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidClientException" -> InvalidClientExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "SlowDownException" -> SlowDownExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SsoOidcException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartDeviceAuthorizationOperationBody(builder: StartDeviceAuthorizationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceCode"))
    val EXPIRESIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("expiresIn"))
    val INTERVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("interval"))
    val USERCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userCode"))
    val VERIFICATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("verificationUri"))
    val VERIFICATIONURICOMPLETE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("verificationUriComplete"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICECODE_DESCRIPTOR)
        field(EXPIRESIN_DESCRIPTOR)
        field(INTERVAL_DESCRIPTOR)
        field(USERCODE_DESCRIPTOR)
        field(VERIFICATIONURI_DESCRIPTOR)
        field(VERIFICATIONURICOMPLETE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICECODE_DESCRIPTOR.index -> builder.deviceCode = deserializeString()
                EXPIRESIN_DESCRIPTOR.index -> builder.expiresIn = deserializeInt()
                INTERVAL_DESCRIPTOR.index -> builder.interval = deserializeInt()
                USERCODE_DESCRIPTOR.index -> builder.userCode = deserializeString()
                VERIFICATIONURI_DESCRIPTOR.index -> builder.verificationUri = deserializeString()
                VERIFICATIONURICOMPLETE_DESCRIPTOR.index -> builder.verificationUriComplete = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
