// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.serde

import aws.sdk.kotlin.services.ssooidc.model.RegisterClientResponse
import aws.sdk.kotlin.services.ssooidc.model.SsoOidcException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterClientOperationDeserializer: HttpDeserialize<RegisterClientResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RegisterClientResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRegisterClientError(context, call)
        }
        val builder = RegisterClientResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterClientOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRegisterClientError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsoOidcException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidClientMetadataException" -> InvalidClientMetadataExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidScopeException" -> InvalidScopeExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SsoOidcException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterClientOperationBody(builder: RegisterClientResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHORIZATIONENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizationEndpoint"))
    val CLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientId"))
    val CLIENTIDISSUEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("clientIdIssuedAt"))
    val CLIENTSECRET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientSecret"))
    val CLIENTSECRETEXPIRESAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("clientSecretExpiresAt"))
    val TOKENENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenEndpoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZATIONENDPOINT_DESCRIPTOR)
        field(CLIENTID_DESCRIPTOR)
        field(CLIENTIDISSUEDAT_DESCRIPTOR)
        field(CLIENTSECRET_DESCRIPTOR)
        field(CLIENTSECRETEXPIRESAT_DESCRIPTOR)
        field(TOKENENDPOINT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHORIZATIONENDPOINT_DESCRIPTOR.index -> builder.authorizationEndpoint = deserializeString()
                CLIENTID_DESCRIPTOR.index -> builder.clientId = deserializeString()
                CLIENTIDISSUEDAT_DESCRIPTOR.index -> builder.clientIdIssuedAt = deserializeLong()
                CLIENTSECRET_DESCRIPTOR.index -> builder.clientSecret = deserializeString()
                CLIENTSECRETEXPIRESAT_DESCRIPTOR.index -> builder.clientSecretExpiresAt = deserializeLong()
                TOKENENDPOINT_DESCRIPTOR.index -> builder.tokenEndpoint = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
