// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "oidc.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "ap-northeast-1" to EndpointDefinition(
                hostname = "oidc.ap-northeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-1",),
            ),
            "ap-northeast-2" to EndpointDefinition(
                hostname = "oidc.ap-northeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-2",),
            ),
            "ap-south-1" to EndpointDefinition(
                hostname = "oidc.ap-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-south-1",),
            ),
            "ap-southeast-1" to EndpointDefinition(
                hostname = "oidc.ap-southeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-1",),
            ),
            "ap-southeast-2" to EndpointDefinition(
                hostname = "oidc.ap-southeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-2",),
            ),
            "ca-central-1" to EndpointDefinition(
                hostname = "oidc.ca-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ca-central-1",),
            ),
            "eu-central-1" to EndpointDefinition(
                hostname = "oidc.eu-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-central-1",),
            ),
            "eu-north-1" to EndpointDefinition(
                hostname = "oidc.eu-north-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-north-1",),
            ),
            "eu-west-1" to EndpointDefinition(
                hostname = "oidc.eu-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-1",),
            ),
            "eu-west-2" to EndpointDefinition(
                hostname = "oidc.eu-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-2",),
            ),
            "eu-west-3" to EndpointDefinition(
                hostname = "oidc.eu-west-3.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-3",),
            ),
            "us-east-1" to EndpointDefinition(
                hostname = "oidc.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "us-east-2" to EndpointDefinition(
                hostname = "oidc.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
            ),
            "us-west-2" to EndpointDefinition(
                hostname = "oidc.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "oidc.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "oidc.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "oidc.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "oidc.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
)
