// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.model



class CreateTokenRequest private constructor(builder: Builder) {
    /**
     * The unique identifier string for each client. This value should come from the persisted result of the RegisterClient API.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * A secret string generated for the client. This value should come from the persisted result of the RegisterClient API.
     */
    val clientSecret: kotlin.String? = builder.clientSecret
    /**
     * The authorization code received from the authorization service. This parameter is required to perform an authorization grant request to get access to a token.
     */
    val code: kotlin.String? = builder.code
    /**
     * Used only when calling this API for the device code grant type. This short-term code is
     * used to identify this authentication attempt. This should come from an in-memory reference to
     * the result of the StartDeviceAuthorization API.
     */
    val deviceCode: kotlin.String? = builder.deviceCode
    /**
     * Supports grant types for authorization code, refresh token, and device code request.
     */
    val grantType: kotlin.String? = builder.grantType
    /**
     * The location of the application that will receive the authorization code. Users authorize
     * the service to send the request to this location.
     */
    val redirectUri: kotlin.String? = builder.redirectUri
    /**
     * The token used to obtain an access token in the event that the access token is invalid or expired. This token is not issued by the service.
     */
    val refreshToken: kotlin.String? = builder.refreshToken
    /**
     * The list of scopes that is defined by the client. Upon authorization, this list is used to
     * restrict permissions when granting an access token.
     */
    val scope: List<String>? = builder.scope

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTokenRequest(")
        append("clientId=$clientId,")
        append("clientSecret=$clientSecret,")
        append("code=$code,")
        append("deviceCode=$deviceCode,")
        append("grantType=$grantType,")
        append("redirectUri=$redirectUri,")
        append("refreshToken=$refreshToken,")
        append("scope=$scope)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (clientSecret?.hashCode() ?: 0)
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (deviceCode?.hashCode() ?: 0)
        result = 31 * result + (grantType?.hashCode() ?: 0)
        result = 31 * result + (redirectUri?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTokenRequest

        if (clientId != other.clientId) return false
        if (clientSecret != other.clientSecret) return false
        if (code != other.code) return false
        if (deviceCode != other.deviceCode) return false
        if (grantType != other.grantType) return false
        if (redirectUri != other.redirectUri) return false
        if (refreshToken != other.refreshToken) return false
        if (scope != other.scope) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier string for each client. This value should come from the persisted result of the RegisterClient API.
         */
        var clientId: kotlin.String? = null
        /**
         * A secret string generated for the client. This value should come from the persisted result of the RegisterClient API.
         */
        var clientSecret: kotlin.String? = null
        /**
         * The authorization code received from the authorization service. This parameter is required to perform an authorization grant request to get access to a token.
         */
        var code: kotlin.String? = null
        /**
         * Used only when calling this API for the device code grant type. This short-term code is
         * used to identify this authentication attempt. This should come from an in-memory reference to
         * the result of the StartDeviceAuthorization API.
         */
        var deviceCode: kotlin.String? = null
        /**
         * Supports grant types for authorization code, refresh token, and device code request.
         */
        var grantType: kotlin.String? = null
        /**
         * The location of the application that will receive the authorization code. Users authorize
         * the service to send the request to this location.
         */
        var redirectUri: kotlin.String? = null
        /**
         * The token used to obtain an access token in the event that the access token is invalid or expired. This token is not issued by the service.
         */
        var refreshToken: kotlin.String? = null
        /**
         * The list of scopes that is defined by the client. Upon authorization, this list is used to
         * restrict permissions when granting an access token.
         */
        var scope: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest) : this() {
            this.clientId = x.clientId
            this.clientSecret = x.clientSecret
            this.code = x.code
            this.deviceCode = x.deviceCode
            this.grantType = x.grantType
            this.redirectUri = x.redirectUri
            this.refreshToken = x.refreshToken
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest = CreateTokenRequest(this)
    }
}
