// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RegisterClientRequest private constructor(builder: Builder) {
    /**
     * The friendly name of the client.
     */
    public val clientName: kotlin.String? = builder.clientName
    /**
     * The type of client. The service supports only `public` as a client type. Anything other than public will be rejected by the service.
     */
    public val clientType: kotlin.String? = builder.clientType
    /**
     * This IAM Identity Center application ARN is used to define administrator-managed configuration for public client access to resources. At authorization, the scopes, grants, and redirect URI available to this client will be restricted by this application resource.
     */
    public val entitledApplicationArn: kotlin.String? = builder.entitledApplicationArn
    /**
     * The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token granting flows available to the client.
     */
    public val grantTypes: List<String>? = builder.grantTypes
    /**
     * The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is needed for user access to resources through the client.
     */
    public val issuerUrl: kotlin.String? = builder.issuerUrl
    /**
     * The list of redirect URI that are defined by the client. At completion of authorization, this list is used to restrict what locations the user agent can be redirected back to.
     */
    public val redirectUris: List<String>? = builder.redirectUris
    /**
     * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions when granting an access token.
     */
    public val scopes: List<String>? = builder.scopes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssooidc.model.RegisterClientRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterClientRequest(")
        append("clientName=$clientName,")
        append("clientType=$clientType,")
        append("entitledApplicationArn=$entitledApplicationArn,")
        append("grantTypes=$grantTypes,")
        append("issuerUrl=$issuerUrl,")
        append("redirectUris=$redirectUris,")
        append("scopes=$scopes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientName?.hashCode() ?: 0
        result = 31 * result + (clientType?.hashCode() ?: 0)
        result = 31 * result + (entitledApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (grantTypes?.hashCode() ?: 0)
        result = 31 * result + (issuerUrl?.hashCode() ?: 0)
        result = 31 * result + (redirectUris?.hashCode() ?: 0)
        result = 31 * result + (scopes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterClientRequest

        if (clientName != other.clientName) return false
        if (clientType != other.clientType) return false
        if (entitledApplicationArn != other.entitledApplicationArn) return false
        if (grantTypes != other.grantTypes) return false
        if (issuerUrl != other.issuerUrl) return false
        if (redirectUris != other.redirectUris) return false
        if (scopes != other.scopes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssooidc.model.RegisterClientRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The friendly name of the client.
         */
        public var clientName: kotlin.String? = null
        /**
         * The type of client. The service supports only `public` as a client type. Anything other than public will be rejected by the service.
         */
        public var clientType: kotlin.String? = null
        /**
         * This IAM Identity Center application ARN is used to define administrator-managed configuration for public client access to resources. At authorization, the scopes, grants, and redirect URI available to this client will be restricted by this application resource.
         */
        public var entitledApplicationArn: kotlin.String? = null
        /**
         * The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token granting flows available to the client.
         */
        public var grantTypes: List<String>? = null
        /**
         * The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is needed for user access to resources through the client.
         */
        public var issuerUrl: kotlin.String? = null
        /**
         * The list of redirect URI that are defined by the client. At completion of authorization, this list is used to restrict what locations the user agent can be redirected back to.
         */
        public var redirectUris: List<String>? = null
        /**
         * The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions when granting an access token.
         */
        public var scopes: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssooidc.model.RegisterClientRequest) : this() {
            this.clientName = x.clientName
            this.clientType = x.clientType
            this.entitledApplicationArn = x.entitledApplicationArn
            this.grantTypes = x.grantTypes
            this.issuerUrl = x.issuerUrl
            this.redirectUris = x.redirectUris
            this.scopes = x.scopes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssooidc.model.RegisterClientRequest = RegisterClientRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
