// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateTokenWithIamResponse private constructor(builder: Builder) {
    /**
     * A bearer token to access Amazon Web Services accounts and applications assigned to a user.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * Indicates the time in seconds when an access token will expire.
     */
    public val expiresIn: kotlin.Int = builder.expiresIn
    /**
     * A JSON Web Token (JWT) that identifies the user associated with the issued access token.
     */
    public val idToken: kotlin.String? = builder.idToken
    /**
     * Indicates the type of tokens that are issued by IAM Identity Center. The following values are supported:
     *
     * * Access Token - `urn:ietf:params:oauth:token-type:access_token`
     *
     * * Refresh Token - `urn:ietf:params:oauth:token-type:refresh_token`
     */
    public val issuedTokenType: kotlin.String? = builder.issuedTokenType
    /**
     * A token that, if present, can be used to refresh a previously issued access token that might have expired.
     *
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see *Considerations for Using this Guide* in the [IAM Identity Center OIDC API Reference](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html).
     */
    public val refreshToken: kotlin.String? = builder.refreshToken
    /**
     * The list of scopes for which authorization is granted. The access token that is issued is limited to the scopes that are granted.
     */
    public val scope: List<String>? = builder.scope
    /**
     * Used to notify the requester that the returned token is an access token. The supported token type is `Bearer`.
     */
    public val tokenType: kotlin.String? = builder.tokenType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTokenWithIamResponse(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("expiresIn=$expiresIn,")
        append("idToken=*** Sensitive Data Redacted ***,")
        append("issuedTokenType=$issuedTokenType,")
        append("refreshToken=*** Sensitive Data Redacted ***,")
        append("scope=$scope,")
        append("tokenType=$tokenType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (expiresIn)
        result = 31 * result + (idToken?.hashCode() ?: 0)
        result = 31 * result + (issuedTokenType?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (tokenType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTokenWithIamResponse

        if (accessToken != other.accessToken) return false
        if (expiresIn != other.expiresIn) return false
        if (idToken != other.idToken) return false
        if (issuedTokenType != other.issuedTokenType) return false
        if (refreshToken != other.refreshToken) return false
        if (scope != other.scope) return false
        if (tokenType != other.tokenType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A bearer token to access Amazon Web Services accounts and applications assigned to a user.
         */
        public var accessToken: kotlin.String? = null
        /**
         * Indicates the time in seconds when an access token will expire.
         */
        public var expiresIn: kotlin.Int = 0
        /**
         * A JSON Web Token (JWT) that identifies the user associated with the issued access token.
         */
        public var idToken: kotlin.String? = null
        /**
         * Indicates the type of tokens that are issued by IAM Identity Center. The following values are supported:
         *
         * * Access Token - `urn:ietf:params:oauth:token-type:access_token`
         *
         * * Refresh Token - `urn:ietf:params:oauth:token-type:refresh_token`
         */
        public var issuedTokenType: kotlin.String? = null
        /**
         * A token that, if present, can be used to refresh a previously issued access token that might have expired.
         *
         * For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see *Considerations for Using this Guide* in the [IAM Identity Center OIDC API Reference](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html).
         */
        public var refreshToken: kotlin.String? = null
        /**
         * The list of scopes for which authorization is granted. The access token that is issued is limited to the scopes that are granted.
         */
        public var scope: List<String>? = null
        /**
         * Used to notify the requester that the returned token is an access token. The supported token type is `Bearer`.
         */
        public var tokenType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamResponse) : this() {
            this.accessToken = x.accessToken
            this.expiresIn = x.expiresIn
            this.idToken = x.idToken
            this.issuedTokenType = x.issuedTokenType
            this.refreshToken = x.refreshToken
            this.scope = x.scope
            this.tokenType = x.tokenType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamResponse = CreateTokenWithIamResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
