// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateTokenRequest private constructor(builder: Builder) {
    /**
     * The unique identifier string for the client or application. This value comes from the result of the RegisterClient API.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * A secret string generated for the client. This value should come from the persisted result of the RegisterClient API.
     */
    public val clientSecret: kotlin.String? = builder.clientSecret
    /**
     * Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify this authorization request. This grant type is currently unsupported for the CreateToken API.
     */
    public val code: kotlin.String? = builder.code
    /**
     * Used only when calling this API for the Authorization Code grant type. This value is generated by the client and presented to validate the original code challenge value the client passed at authorization time.
     */
    public val codeVerifier: kotlin.String? = builder.codeVerifier
    /**
     * Used only when calling this API for the Device Code grant type. This short-term code is used to identify this authorization request. This comes from the result of the StartDeviceAuthorization API.
     */
    public val deviceCode: kotlin.String? = builder.deviceCode
    /**
     * Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values, depending on the grant type that you want:
     *
     * * Device Code - `urn:ietf:params:oauth:grant-type:device_code`
     *
     * * Refresh Token - `refresh_token`
     *
     * For information about how to obtain the device code, see the StartDeviceAuthorization topic.
     */
    public val grantType: kotlin.String? = builder.grantType
    /**
     * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.
     */
    public val redirectUri: kotlin.String? = builder.redirectUri
    /**
     * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.
     *
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see *Considerations for Using this Guide* in the [IAM Identity Center OIDC API Reference](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html).
     */
    public val refreshToken: kotlin.String? = builder.refreshToken
    /**
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured for the client during the call to RegisterClient.
     */
    public val scope: List<String>? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTokenRequest(")
        append("clientId=$clientId,")
        append("clientSecret=*** Sensitive Data Redacted ***,")
        append("code=$code,")
        append("codeVerifier=*** Sensitive Data Redacted ***,")
        append("deviceCode=$deviceCode,")
        append("grantType=$grantType,")
        append("redirectUri=$redirectUri,")
        append("refreshToken=*** Sensitive Data Redacted ***,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId?.hashCode() ?: 0
        result = 31 * result + (clientSecret?.hashCode() ?: 0)
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (codeVerifier?.hashCode() ?: 0)
        result = 31 * result + (deviceCode?.hashCode() ?: 0)
        result = 31 * result + (grantType?.hashCode() ?: 0)
        result = 31 * result + (redirectUri?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTokenRequest

        if (clientId != other.clientId) return false
        if (clientSecret != other.clientSecret) return false
        if (code != other.code) return false
        if (codeVerifier != other.codeVerifier) return false
        if (deviceCode != other.deviceCode) return false
        if (grantType != other.grantType) return false
        if (redirectUri != other.redirectUri) return false
        if (refreshToken != other.refreshToken) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier string for the client or application. This value comes from the result of the RegisterClient API.
         */
        public var clientId: kotlin.String? = null
        /**
         * A secret string generated for the client. This value should come from the persisted result of the RegisterClient API.
         */
        public var clientSecret: kotlin.String? = null
        /**
         * Used only when calling this API for the Authorization Code grant type. The short-term code is used to identify this authorization request. This grant type is currently unsupported for the CreateToken API.
         */
        public var code: kotlin.String? = null
        /**
         * Used only when calling this API for the Authorization Code grant type. This value is generated by the client and presented to validate the original code challenge value the client passed at authorization time.
         */
        public var codeVerifier: kotlin.String? = null
        /**
         * Used only when calling this API for the Device Code grant type. This short-term code is used to identify this authorization request. This comes from the result of the StartDeviceAuthorization API.
         */
        public var deviceCode: kotlin.String? = null
        /**
         * Supports the following OAuth grant types: Device Code and Refresh Token. Specify either of the following values, depending on the grant type that you want:
         *
         * * Device Code - `urn:ietf:params:oauth:grant-type:device_code`
         *
         * * Refresh Token - `refresh_token`
         *
         * For information about how to obtain the device code, see the StartDeviceAuthorization topic.
         */
        public var grantType: kotlin.String? = null
        /**
         * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.
         */
        public var redirectUri: kotlin.String? = null
        /**
         * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.
         *
         * For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see *Considerations for Using this Guide* in the [IAM Identity Center OIDC API Reference](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html).
         */
        public var refreshToken: kotlin.String? = null
        /**
         * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If this value is not specified, IAM Identity Center authorizes all scopes that are configured for the client during the call to RegisterClient.
         */
        public var scope: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest) : this() {
            this.clientId = x.clientId
            this.clientSecret = x.clientSecret
            this.code = x.code
            this.codeVerifier = x.codeVerifier
            this.deviceCode = x.deviceCode
            this.grantType = x.grantType
            this.redirectUri = x.redirectUri
            this.refreshToken = x.refreshToken
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssooidc.model.CreateTokenRequest = CreateTokenRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
