// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.serde

import aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamResponse
import aws.sdk.kotlin.services.ssooidc.model.SsoOidcException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateTokenWithIAMOperationDeserializer: HttpDeserialize<CreateTokenWithIamResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateTokenWithIamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateTokenWithIamError(context, call)
        }
        val builder = CreateTokenWithIamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateTokenWithIAMOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateTokenWithIamError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsoOidcException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestRegionException" -> InvalidRequestRegionExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidGrantException" -> InvalidGrantExceptionDeserializer().deserialize(context, wrappedCall)
        "AuthorizationPendingException" -> AuthorizationPendingExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidScopeException" -> InvalidScopeExceptionDeserializer().deserialize(context, wrappedCall)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "SlowDownException" -> SlowDownExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedGrantTypeException" -> UnsupportedGrantTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidClientException" -> InvalidClientExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SsoOidcException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateTokenWithIAMOperationBody(builder: CreateTokenWithIamResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessToken"))
    val EXPIRESIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("expiresIn"))
    val IDTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("idToken"))
    val ISSUEDTOKENTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("issuedTokenType"))
    val REFRESHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("refreshToken"))
    val SCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("scope"))
    val TOKENTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSTOKEN_DESCRIPTOR)
        field(EXPIRESIN_DESCRIPTOR)
        field(IDTOKEN_DESCRIPTOR)
        field(ISSUEDTOKENTYPE_DESCRIPTOR)
        field(REFRESHTOKEN_DESCRIPTOR)
        field(SCOPE_DESCRIPTOR)
        field(TOKENTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSTOKEN_DESCRIPTOR.index -> builder.accessToken = deserializeString()
                EXPIRESIN_DESCRIPTOR.index -> builder.expiresIn = deserializeInt()
                IDTOKEN_DESCRIPTOR.index -> builder.idToken = deserializeString()
                ISSUEDTOKENTYPE_DESCRIPTOR.index -> builder.issuedTokenType = deserializeString()
                REFRESHTOKEN_DESCRIPTOR.index -> builder.refreshToken = deserializeString()
                SCOPE_DESCRIPTOR.index -> builder.scope =
                    deserializer.deserializeList(SCOPE_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOKENTYPE_DESCRIPTOR.index -> builder.tokenType = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
