// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Indicates that a token provided as input to the request was issued by and is only usable by calling IAM Identity Center endpoints in another region.
 */
public class InvalidRequestRegionException private constructor(builder: Builder) : SsoOidcException() {

    /**
     * Indicates the IAM Identity Center endpoint which the requester may call with this token.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * Single error code. For this exception the value will be `invalid_request`.
     */
    public val error: kotlin.String? = builder.error
    /**
     * Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.
     */
    public val errorDescription: kotlin.String? = builder.errorDescription
    /**
     * Indicates the region which the requester may call with this token.
     */
    public val region: kotlin.String? = builder.region

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssooidc.model.InvalidRequestRegionException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidRequestRegionException(")
        append("endpoint=$endpoint,")
        append("error=$error,")
        append("errorDescription=$errorDescription,")
        append("region=$region")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpoint?.hashCode() ?: 0
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (errorDescription?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidRequestRegionException

        if (endpoint != other.endpoint) return false
        if (error != other.error) return false
        if (errorDescription != other.errorDescription) return false
        if (region != other.region) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssooidc.model.InvalidRequestRegionException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the IAM Identity Center endpoint which the requester may call with this token.
         */
        public var endpoint: kotlin.String? = null
        /**
         * Single error code. For this exception the value will be `invalid_request`.
         */
        public var error: kotlin.String? = null
        /**
         * Human-readable text providing additional information, used to assist the client developer in understanding the error that occurred.
         */
        public var errorDescription: kotlin.String? = null
        /**
         * Indicates the region which the requester may call with this token.
         */
        public var region: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssooidc.model.InvalidRequestRegionException) : this() {
            this.endpoint = x.endpoint
            this.error = x.error
            this.errorDescription = x.errorDescription
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssooidc.model.InvalidRequestRegionException = InvalidRequestRegionException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
