// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.model



public class CreateTokenWithIamRequest private constructor(builder: Builder) {
    /**
     * Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for the application.
     */
    public val assertion: kotlin.String? = builder.assertion
    /**
     * The unique identifier string for the client or application. This value is an application ARN that has OAuth grants configured.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * Used only when calling this API for the Authorization Code grant type. This short-term code is used to identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI persisted in the Authorization Code GrantOptions for the application.
     */
    public val code: kotlin.String? = builder.code
    /**
     * Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on the grant type that you want:
     *
     * * Authorization Code - `authorization_code`
     *
     * * Refresh Token - `refresh_token`
     *
     * * JWT Bearer - `urn:ietf:params:oauth:grant-type:jwt-bearer`
     *
     * * Token Exchange - `urn:ietf:params:oauth:grant-type:token-exchange`
     */
    public val grantType: kotlin.String? = builder.grantType
    /**
     * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.
     */
    public val redirectUri: kotlin.String? = builder.redirectUri
    /**
     * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.
     *
     * For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see *Considerations for Using this Guide* in the [IAM Identity Center OIDC API Reference](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html).
     */
    public val refreshToken: kotlin.String? = builder.refreshToken
    /**
     * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that the requester can receive. The following values are supported:
     *
     * * Access Token - `urn:ietf:params:oauth:token-type:access_token`
     *
     * * Refresh Token - `urn:ietf:params:oauth:token-type:refresh_token`
     */
    public val requestedTokenType: kotlin.String? = builder.requestedTokenType
    /**
     * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the application, including the following default scopes: `openid`, `aws`, `sts:identity_context`.
     */
    public val scope: List<String>? = builder.scope
    /**
     * Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different client or application. The access token must have authorized scopes that indicate the requested application as a target audience.
     */
    public val subjectToken: kotlin.String? = builder.subjectToken
    /**
     * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is passed as the subject of the exchange. The following value is supported:
     *
     * * Access Token - `urn:ietf:params:oauth:token-type:access_token`
     */
    public val subjectTokenType: kotlin.String? = builder.subjectTokenType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTokenWithIamRequest(")
        append("assertion=*** Sensitive Data Redacted ***,")
        append("clientId=$clientId,")
        append("code=$code,")
        append("grantType=$grantType,")
        append("redirectUri=$redirectUri,")
        append("refreshToken=*** Sensitive Data Redacted ***,")
        append("requestedTokenType=$requestedTokenType,")
        append("scope=$scope,")
        append("subjectToken=*** Sensitive Data Redacted ***,")
        append("subjectTokenType=$subjectTokenType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assertion?.hashCode() ?: 0
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (code?.hashCode() ?: 0)
        result = 31 * result + (grantType?.hashCode() ?: 0)
        result = 31 * result + (redirectUri?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        result = 31 * result + (requestedTokenType?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (subjectToken?.hashCode() ?: 0)
        result = 31 * result + (subjectTokenType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTokenWithIamRequest

        if (assertion != other.assertion) return false
        if (clientId != other.clientId) return false
        if (code != other.code) return false
        if (grantType != other.grantType) return false
        if (redirectUri != other.redirectUri) return false
        if (refreshToken != other.refreshToken) return false
        if (requestedTokenType != other.requestedTokenType) return false
        if (scope != other.scope) return false
        if (subjectToken != other.subjectToken) return false
        if (subjectTokenType != other.subjectTokenType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for the application.
         */
        public var assertion: kotlin.String? = null
        /**
         * The unique identifier string for the client or application. This value is an application ARN that has OAuth grants configured.
         */
        public var clientId: kotlin.String? = null
        /**
         * Used only when calling this API for the Authorization Code grant type. This short-term code is used to identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI persisted in the Authorization Code GrantOptions for the application.
         */
        public var code: kotlin.String? = null
        /**
         * Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on the grant type that you want:
         *
         * * Authorization Code - `authorization_code`
         *
         * * Refresh Token - `refresh_token`
         *
         * * JWT Bearer - `urn:ietf:params:oauth:grant-type:jwt-bearer`
         *
         * * Token Exchange - `urn:ietf:params:oauth:grant-type:token-exchange`
         */
        public var grantType: kotlin.String? = null
        /**
         * Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.
         */
        public var redirectUri: kotlin.String? = null
        /**
         * Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.
         *
         * For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see *Considerations for Using this Guide* in the [IAM Identity Center OIDC API Reference](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html).
         */
        public var refreshToken: kotlin.String? = null
        /**
         * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that the requester can receive. The following values are supported:
         *
         * * Access Token - `urn:ietf:params:oauth:token-type:access_token`
         *
         * * Refresh Token - `urn:ietf:params:oauth:token-type:refresh_token`
         */
        public var requestedTokenType: kotlin.String? = null
        /**
         * The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the application, including the following default scopes: `openid`, `aws`, `sts:identity_context`.
         */
        public var scope: List<String>? = null
        /**
         * Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different client or application. The access token must have authorized scopes that indicate the requested application as a target audience.
         */
        public var subjectToken: kotlin.String? = null
        /**
         * Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is passed as the subject of the exchange. The following value is supported:
         *
         * * Access Token - `urn:ietf:params:oauth:token-type:access_token`
         */
        public var subjectTokenType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamRequest) : this() {
            this.assertion = x.assertion
            this.clientId = x.clientId
            this.code = x.code
            this.grantType = x.grantType
            this.redirectUri = x.redirectUri
            this.refreshToken = x.refreshToken
            this.requestedTokenType = x.requestedTokenType
            this.scope = x.scope
            this.subjectToken = x.subjectToken
            this.subjectTokenType = x.subjectTokenType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssooidc.model.CreateTokenWithIamRequest = CreateTokenWithIamRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
