// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.serde

import aws.sdk.kotlin.services.ssoadmin.model.DescribeTrustedTokenIssuerResponse
import aws.sdk.kotlin.services.ssoadmin.model.SsoAdminException
import aws.sdk.kotlin.services.ssoadmin.model.TrustedTokenIssuerConfiguration
import aws.sdk.kotlin.services.ssoadmin.model.TrustedTokenIssuerType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeTrustedTokenIssuerOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTrustedTokenIssuerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTrustedTokenIssuerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTrustedTokenIssuerError(context, call, payload)
        }
        val builder = DescribeTrustedTokenIssuerResponse.Builder()

        if (payload != null) {
            deserializeDescribeTrustedTokenIssuerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTrustedTokenIssuerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsoAdminException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsoAdminException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTrustedTokenIssuerOperationBody(builder: DescribeTrustedTokenIssuerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val TRUSTEDTOKENISSUERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TrustedTokenIssuerArn"))
    val TRUSTEDTOKENISSUERCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrustedTokenIssuerConfiguration"))
    val TRUSTEDTOKENISSUERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("TrustedTokenIssuerType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAME_DESCRIPTOR)
        field(TRUSTEDTOKENISSUERARN_DESCRIPTOR)
        field(TRUSTEDTOKENISSUERCONFIGURATION_DESCRIPTOR)
        field(TRUSTEDTOKENISSUERTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                TRUSTEDTOKENISSUERARN_DESCRIPTOR.index -> builder.trustedTokenIssuerArn = deserializeString()
                TRUSTEDTOKENISSUERCONFIGURATION_DESCRIPTOR.index -> builder.trustedTokenIssuerConfiguration = deserializeTrustedTokenIssuerConfigurationDocument(deserializer)
                TRUSTEDTOKENISSUERTYPE_DESCRIPTOR.index -> builder.trustedTokenIssuerType = deserializeString().let { TrustedTokenIssuerType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
