// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.serde

import aws.sdk.kotlin.services.ssoadmin.model.DescribeApplicationProviderResponse
import aws.sdk.kotlin.services.ssoadmin.model.DisplayData
import aws.sdk.kotlin.services.ssoadmin.model.FederationProtocol
import aws.sdk.kotlin.services.ssoadmin.model.ResourceServerConfig
import aws.sdk.kotlin.services.ssoadmin.model.SsoAdminException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeApplicationProviderOperationDeserializer: HttpDeserializer.NonStreaming<DescribeApplicationProviderResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeApplicationProviderResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeApplicationProviderError(context, call, payload)
        }
        val builder = DescribeApplicationProviderResponse.Builder()

        if (payload != null) {
            deserializeDescribeApplicationProviderOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeApplicationProviderError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsoAdminException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsoAdminException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeApplicationProviderOperationBody(builder: DescribeApplicationProviderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONPROVIDERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationProviderArn"))
    val DISPLAYDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DisplayData"))
    val FEDERATIONPROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("FederationProtocol"))
    val RESOURCESERVERCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ResourceServerConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONPROVIDERARN_DESCRIPTOR)
        field(DISPLAYDATA_DESCRIPTOR)
        field(FEDERATIONPROTOCOL_DESCRIPTOR)
        field(RESOURCESERVERCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONPROVIDERARN_DESCRIPTOR.index -> builder.applicationProviderArn = deserializeString()
                DISPLAYDATA_DESCRIPTOR.index -> builder.displayData = deserializeDisplayDataDocument(deserializer)
                FEDERATIONPROTOCOL_DESCRIPTOR.index -> builder.federationProtocol = deserializeString().let { FederationProtocol.fromValue(it) }
                RESOURCESERVERCONFIG_DESCRIPTOR.index -> builder.resourceServerConfig = deserializeResourceServerConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
