// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model



/**
 * A structure that describes the sign-in options for an application portal.
 */
public class SignInOptions private constructor(builder: Builder) {
    /**
     * The URL that accepts authentication requests for an application. This is a required parameter if the `Origin` parameter is `APPLICATION`.
     */
    public val applicationUrl: kotlin.String? = builder.applicationUrl
    /**
     * This determines how IAM Identity Center navigates the user to the target application. It can be one of the following values:
     * + `APPLICATION`: IAM Identity Center redirects the customer to the configured `ApplicationUrl`.
     * + `IDENTITY_CENTER`: IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
     */
    public val origin: aws.sdk.kotlin.services.ssoadmin.model.SignInOrigin = requireNotNull(builder.origin) { "A non-null value must be provided for origin" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.SignInOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SignInOptions(")
        append("applicationUrl=$applicationUrl,")
        append("origin=$origin")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationUrl?.hashCode() ?: 0
        result = 31 * result + (origin.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SignInOptions

        if (applicationUrl != other.applicationUrl) return false
        if (origin != other.origin) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.SignInOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URL that accepts authentication requests for an application. This is a required parameter if the `Origin` parameter is `APPLICATION`.
         */
        public var applicationUrl: kotlin.String? = null
        /**
         * This determines how IAM Identity Center navigates the user to the target application. It can be one of the following values:
         * + `APPLICATION`: IAM Identity Center redirects the customer to the configured `ApplicationUrl`.
         * + `IDENTITY_CENTER`: IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
         */
        public var origin: aws.sdk.kotlin.services.ssoadmin.model.SignInOrigin? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.SignInOptions) : this() {
            this.applicationUrl = x.applicationUrl
            this.origin = x.origin
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.SignInOptions = SignInOptions(this)

        internal fun correctErrors(): Builder {
            if (origin == null) origin = SignInOrigin.SdkUnknown("no value provided")
            return this
        }
    }
}
