// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model



/**
 * A structure that describes configuration settings for a trusted token issuer that supports OpenID Connect (OIDC) and JSON Web Tokens (JWTs).
 */
public class OidcJwtConfiguration private constructor(builder: Builder) {
    /**
     * The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `IdentityStoreAttributePath` when a trusted token issuer token is exchanged for an IAM Identity Center token.
     */
    public val claimAttributePath: kotlin.String = requireNotNull(builder.claimAttributePath) { "A non-null value must be provided for claimAttributePath" }
    /**
     * The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `ClaimAttributePath` when a trusted token issuer token is exchanged for an IAM Identity Center token.
     */
    public val identityStoreAttributePath: kotlin.String = requireNotNull(builder.identityStoreAttributePath) { "A non-null value must be provided for identityStoreAttributePath" }
    /**
     * The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
     */
    public val issuerUrl: kotlin.String = requireNotNull(builder.issuerUrl) { "A non-null value must be provided for issuerUrl" }
    /**
     * The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
     */
    public val jwksRetrievalOption: aws.sdk.kotlin.services.ssoadmin.model.JwksRetrievalOption = requireNotNull(builder.jwksRetrievalOption) { "A non-null value must be provided for jwksRetrievalOption" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.OidcJwtConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OidcJwtConfiguration(")
        append("claimAttributePath=$claimAttributePath,")
        append("identityStoreAttributePath=$identityStoreAttributePath,")
        append("issuerUrl=$issuerUrl,")
        append("jwksRetrievalOption=$jwksRetrievalOption")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = claimAttributePath.hashCode()
        result = 31 * result + (identityStoreAttributePath.hashCode())
        result = 31 * result + (issuerUrl.hashCode())
        result = 31 * result + (jwksRetrievalOption.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OidcJwtConfiguration

        if (claimAttributePath != other.claimAttributePath) return false
        if (identityStoreAttributePath != other.identityStoreAttributePath) return false
        if (issuerUrl != other.issuerUrl) return false
        if (jwksRetrievalOption != other.jwksRetrievalOption) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.OidcJwtConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The path of the source attribute in the JWT from the trusted token issuer. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `IdentityStoreAttributePath` when a trusted token issuer token is exchanged for an IAM Identity Center token.
         */
        public var claimAttributePath: kotlin.String? = null
        /**
         * The path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `ClaimAttributePath` when a trusted token issuer token is exchanged for an IAM Identity Center token.
         */
        public var identityStoreAttributePath: kotlin.String? = null
        /**
         * The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
         */
        public var issuerUrl: kotlin.String? = null
        /**
         * The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT.
         */
        public var jwksRetrievalOption: aws.sdk.kotlin.services.ssoadmin.model.JwksRetrievalOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.OidcJwtConfiguration) : this() {
            this.claimAttributePath = x.claimAttributePath
            this.identityStoreAttributePath = x.identityStoreAttributePath
            this.issuerUrl = x.issuerUrl
            this.jwksRetrievalOption = x.jwksRetrievalOption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.OidcJwtConfiguration = OidcJwtConfiguration(this)

        internal fun correctErrors(): Builder {
            if (claimAttributePath == null) claimAttributePath = ""
            if (identityStoreAttributePath == null) identityStoreAttributePath = ""
            if (issuerUrl == null) issuerUrl = ""
            if (jwksRetrievalOption == null) jwksRetrievalOption = JwksRetrievalOption.SdkUnknown("no value provided")
            return this
        }
    }
}
