// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the IAM Identity Center instance.
 */
public class InstanceMetadata private constructor(builder: Builder) {
    /**
     * The date and time that the Identity Center instance was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The identifier of the identity store that is connected to the Identity Center instance.
     */
    public val identityStoreId: kotlin.String? = builder.identityStoreId
    /**
     * The ARN of the Identity Center instance under which the operation will be executed. For more information about ARNs, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val instanceArn: kotlin.String? = builder.instanceArn
    /**
     * The name of the Identity Center instance.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID number of the owner of the Identity Center instance.
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId
    /**
     * The current status of this Identity Center instance.
     */
    public val status: aws.sdk.kotlin.services.ssoadmin.model.InstanceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.InstanceMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceMetadata(")
        append("createdDate=$createdDate,")
        append("identityStoreId=$identityStoreId,")
        append("instanceArn=$instanceArn,")
        append("name=$name,")
        append("ownerAccountId=$ownerAccountId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (identityStoreId?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceMetadata

        if (createdDate != other.createdDate) return false
        if (identityStoreId != other.identityStoreId) return false
        if (instanceArn != other.instanceArn) return false
        if (name != other.name) return false
        if (ownerAccountId != other.ownerAccountId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.InstanceMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the Identity Center instance was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the identity store that is connected to the Identity Center instance.
         */
        public var identityStoreId: kotlin.String? = null
        /**
         * The ARN of the Identity Center instance under which the operation will be executed. For more information about ARNs, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var instanceArn: kotlin.String? = null
        /**
         * The name of the Identity Center instance.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID number of the owner of the Identity Center instance.
         */
        public var ownerAccountId: kotlin.String? = null
        /**
         * The current status of this Identity Center instance.
         */
        public var status: aws.sdk.kotlin.services.ssoadmin.model.InstanceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.InstanceMetadata) : this() {
            this.createdDate = x.createdDate
            this.identityStoreId = x.identityStoreId
            this.instanceArn = x.instanceArn
            this.name = x.name
            this.ownerAccountId = x.ownerAccountId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.InstanceMetadata = InstanceMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
