// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model



public class CreateApplicationRequest private constructor(builder: Builder) {
    /**
     * The ARN of the application provider under which the operation will run.
     */
    public val applicationProviderArn: kotlin.String? = builder.applicationProviderArn
    /**
     * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
     *
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     *
     * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the .
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the instance of IAM Identity Center under which the operation will run. For more information about ARNs, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val instanceArn: kotlin.String? = builder.instanceArn
    /**
     * The name of the .
     */
    public val name: kotlin.String? = builder.name
    /**
     * A structure that describes the options for the portal associated with an application.
     */
    public val portalOptions: aws.sdk.kotlin.services.ssoadmin.model.PortalOptions? = builder.portalOptions
    /**
     * Specifies whether the application is enabled or disabled.
     */
    public val status: aws.sdk.kotlin.services.ssoadmin.model.ApplicationStatus? = builder.status
    /**
     * Specifies tags to be attached to the application.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.CreateApplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationRequest(")
        append("applicationProviderArn=$applicationProviderArn,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("instanceArn=$instanceArn,")
        append("name=$name,")
        append("portalOptions=$portalOptions,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationProviderArn?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (portalOptions?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationRequest

        if (applicationProviderArn != other.applicationProviderArn) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (instanceArn != other.instanceArn) return false
        if (name != other.name) return false
        if (portalOptions != other.portalOptions) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.CreateApplicationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the application provider under which the operation will run.
         */
        public var applicationProviderArn: kotlin.String? = null
        /**
         * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
         *
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         *
         * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The description of the .
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the instance of IAM Identity Center under which the operation will run. For more information about ARNs, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var instanceArn: kotlin.String? = null
        /**
         * The name of the .
         */
        public var name: kotlin.String? = null
        /**
         * A structure that describes the options for the portal associated with an application.
         */
        public var portalOptions: aws.sdk.kotlin.services.ssoadmin.model.PortalOptions? = null
        /**
         * Specifies whether the application is enabled or disabled.
         */
        public var status: aws.sdk.kotlin.services.ssoadmin.model.ApplicationStatus? = null
        /**
         * Specifies tags to be attached to the application.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.CreateApplicationRequest) : this() {
            this.applicationProviderArn = x.applicationProviderArn
            this.clientToken = x.clientToken
            this.description = x.description
            this.instanceArn = x.instanceArn
            this.name = x.name
            this.portalOptions = x.portalOptions
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.CreateApplicationRequest = CreateApplicationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssoadmin.model.PortalOptions] inside the given [block]
         */
        public fun portalOptions(block: aws.sdk.kotlin.services.ssoadmin.model.PortalOptions.Builder.() -> kotlin.Unit) {
            this.portalOptions = aws.sdk.kotlin.services.ssoadmin.model.PortalOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
