// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model



/**
 * A structure that describes a provider that can be used to connect an Amazon Web Services managed application or customer managed application to IAM Identity Center.
 */
public class ApplicationProvider private constructor(builder: Builder) {
    /**
     * The ARN of the application provider.
     */
    public val applicationProviderArn: kotlin.String = requireNotNull(builder.applicationProviderArn) { "A non-null value must be provided for applicationProviderArn" }
    /**
     * A structure that describes how IAM Identity Center represents the application provider in the portal.
     */
    public val displayData: aws.sdk.kotlin.services.ssoadmin.model.DisplayData? = builder.displayData
    /**
     * The protocol that the application provider uses to perform federation.
     */
    public val federationProtocol: aws.sdk.kotlin.services.ssoadmin.model.FederationProtocol? = builder.federationProtocol
    /**
     * A structure that describes the application provider's resource server.
     */
    public val resourceServerConfig: aws.sdk.kotlin.services.ssoadmin.model.ResourceServerConfig? = builder.resourceServerConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.ApplicationProvider = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationProvider(")
        append("applicationProviderArn=$applicationProviderArn,")
        append("displayData=$displayData,")
        append("federationProtocol=$federationProtocol,")
        append("resourceServerConfig=$resourceServerConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationProviderArn.hashCode()
        result = 31 * result + (displayData?.hashCode() ?: 0)
        result = 31 * result + (federationProtocol?.hashCode() ?: 0)
        result = 31 * result + (resourceServerConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationProvider

        if (applicationProviderArn != other.applicationProviderArn) return false
        if (displayData != other.displayData) return false
        if (federationProtocol != other.federationProtocol) return false
        if (resourceServerConfig != other.resourceServerConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.ApplicationProvider = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the application provider.
         */
        public var applicationProviderArn: kotlin.String? = null
        /**
         * A structure that describes how IAM Identity Center represents the application provider in the portal.
         */
        public var displayData: aws.sdk.kotlin.services.ssoadmin.model.DisplayData? = null
        /**
         * The protocol that the application provider uses to perform federation.
         */
        public var federationProtocol: aws.sdk.kotlin.services.ssoadmin.model.FederationProtocol? = null
        /**
         * A structure that describes the application provider's resource server.
         */
        public var resourceServerConfig: aws.sdk.kotlin.services.ssoadmin.model.ResourceServerConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.ApplicationProvider) : this() {
            this.applicationProviderArn = x.applicationProviderArn
            this.displayData = x.displayData
            this.federationProtocol = x.federationProtocol
            this.resourceServerConfig = x.resourceServerConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.ApplicationProvider = ApplicationProvider(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssoadmin.model.DisplayData] inside the given [block]
         */
        public fun displayData(block: aws.sdk.kotlin.services.ssoadmin.model.DisplayData.Builder.() -> kotlin.Unit) {
            this.displayData = aws.sdk.kotlin.services.ssoadmin.model.DisplayData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssoadmin.model.ResourceServerConfig] inside the given [block]
         */
        public fun resourceServerConfig(block: aws.sdk.kotlin.services.ssoadmin.model.ResourceServerConfig.Builder.() -> kotlin.Unit) {
            this.resourceServerConfig = aws.sdk.kotlin.services.ssoadmin.model.ResourceServerConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (applicationProviderArn == null) applicationProviderArn = ""
            return this
        }
    }
}
