// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that describes an application that uses IAM Identity Center for access management.
 */
public class Application private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID number of the application.
     */
    public val applicationAccount: kotlin.String? = builder.applicationAccount
    /**
     * The ARN of the application.
     */
    public val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The ARN of the application provider for this application.
     */
    public val applicationProviderArn: kotlin.String? = builder.applicationProviderArn
    /**
     * The date and time when the application was originally created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The description of the application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the instance of IAM Identity Center that is configured with this application.
     */
    public val instanceArn: kotlin.String? = builder.instanceArn
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A structure that describes the options for the access portal associated with this application.
     */
    public val portalOptions: aws.sdk.kotlin.services.ssoadmin.model.PortalOptions? = builder.portalOptions
    /**
     * The current status of the application in this instance of IAM Identity Center.
     */
    public val status: aws.sdk.kotlin.services.ssoadmin.model.ApplicationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.Application = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Application(")
        append("applicationAccount=$applicationAccount,")
        append("applicationArn=$applicationArn,")
        append("applicationProviderArn=$applicationProviderArn,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("instanceArn=$instanceArn,")
        append("name=$name,")
        append("portalOptions=$portalOptions,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationAccount?.hashCode() ?: 0
        result = 31 * result + (applicationArn?.hashCode() ?: 0)
        result = 31 * result + (applicationProviderArn?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (portalOptions?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Application

        if (applicationAccount != other.applicationAccount) return false
        if (applicationArn != other.applicationArn) return false
        if (applicationProviderArn != other.applicationProviderArn) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (instanceArn != other.instanceArn) return false
        if (name != other.name) return false
        if (portalOptions != other.portalOptions) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.Application = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID number of the application.
         */
        public var applicationAccount: kotlin.String? = null
        /**
         * The ARN of the application.
         */
        public var applicationArn: kotlin.String? = null
        /**
         * The ARN of the application provider for this application.
         */
        public var applicationProviderArn: kotlin.String? = null
        /**
         * The date and time when the application was originally created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the application.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the instance of IAM Identity Center that is configured with this application.
         */
        public var instanceArn: kotlin.String? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * A structure that describes the options for the access portal associated with this application.
         */
        public var portalOptions: aws.sdk.kotlin.services.ssoadmin.model.PortalOptions? = null
        /**
         * The current status of the application in this instance of IAM Identity Center.
         */
        public var status: aws.sdk.kotlin.services.ssoadmin.model.ApplicationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.Application) : this() {
            this.applicationAccount = x.applicationAccount
            this.applicationArn = x.applicationArn
            this.applicationProviderArn = x.applicationProviderArn
            this.createdDate = x.createdDate
            this.description = x.description
            this.instanceArn = x.instanceArn
            this.name = x.name
            this.portalOptions = x.portalOptions
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.Application = Application(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssoadmin.model.PortalOptions] inside the given [block]
         */
        public fun portalOptions(block: aws.sdk.kotlin.services.ssoadmin.model.PortalOptions.Builder.() -> kotlin.Unit) {
            this.portalOptions = aws.sdk.kotlin.services.ssoadmin.model.PortalOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
