// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.ssoadmin.auth.SsoAdminAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.ssoadmin.auth.SsoAdminIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.ssoadmin.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.ssoadmin.model.*
import aws.sdk.kotlin.services.ssoadmin.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultSsoAdminClient(override val config: SsoAdminClient.Config) : SsoAdminClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = SsoAdminIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "sso")
        }
        toMap()
    }
    private val authSchemeAdapter = SsoAdminAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.ssoadmin"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Attaches the specified customer managed policy to the specified PermissionSet.
     */
    override suspend fun attachCustomerManagedPolicyReferenceToPermissionSet(input: AttachCustomerManagedPolicyReferenceToPermissionSetRequest): AttachCustomerManagedPolicyReferenceToPermissionSetResponse {
        val op = SdkHttpOperation.build<AttachCustomerManagedPolicyReferenceToPermissionSetRequest, AttachCustomerManagedPolicyReferenceToPermissionSetResponse> {
            serializeWith = AttachCustomerManagedPolicyReferenceToPermissionSetOperationSerializer()
            deserializeWith = AttachCustomerManagedPolicyReferenceToPermissionSetOperationDeserializer()
            operationName = "AttachCustomerManagedPolicyReferenceToPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an Amazon Web Services managed policy ARN to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this operation. Calling `ProvisionPermissionSet` applies the corresponding IAM policy updates to all assigned accounts.
     */
    override suspend fun attachManagedPolicyToPermissionSet(input: AttachManagedPolicyToPermissionSetRequest): AttachManagedPolicyToPermissionSetResponse {
        val op = SdkHttpOperation.build<AttachManagedPolicyToPermissionSetRequest, AttachManagedPolicyToPermissionSetResponse> {
            serializeWith = AttachManagedPolicyToPermissionSetOperationSerializer()
            deserializeWith = AttachManagedPolicyToPermissionSetOperationDeserializer()
            operationName = "AttachManagedPolicyToPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.
     *
     * The term *principal* here refers to a user or group that is defined in IAM Identity Center.
     *
     * As part of a successful `CreateAccountAssignment` call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call ` <a>ProvisionPermissionSet</a> ` to make these updates.
     *
     *  After a successful response, call `DescribeAccountAssignmentCreationStatus` to describe the status of an assignment creation request.
     */
    override suspend fun createAccountAssignment(input: CreateAccountAssignmentRequest): CreateAccountAssignmentResponse {
        val op = SdkHttpOperation.build<CreateAccountAssignmentRequest, CreateAccountAssignmentResponse> {
            serializeWith = CreateAccountAssignmentOperationSerializer()
            deserializeWith = CreateAccountAssignmentOperationDeserializer()
            operationName = "CreateAccountAssignment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an application in IAM Identity Center for the given application provider.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializeWith = CreateApplicationOperationSerializer()
            deserializeWith = CreateApplicationOperationDeserializer()
            operationName = "CreateApplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Grant application access to a user or group.
     */
    override suspend fun createApplicationAssignment(input: CreateApplicationAssignmentRequest): CreateApplicationAssignmentResponse {
        val op = SdkHttpOperation.build<CreateApplicationAssignmentRequest, CreateApplicationAssignmentResponse> {
            serializeWith = CreateApplicationAssignmentOperationSerializer()
            deserializeWith = CreateApplicationAssignmentOperationDeserializer()
            operationName = "CreateApplicationAssignment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an instance of IAM Identity Center for a standalone Amazon Web Services account that is not managed by Organizations or a member Amazon Web Services account in an organization. You can create only one instance per account and across all Amazon Web Services Regions.
     *
     * The CreateInstance request is rejected if the following apply:
     * + The instance is created within the organization management account.
     * + An instance already exists in the same account.
     */
    override suspend fun createInstance(input: CreateInstanceRequest): CreateInstanceResponse {
        val op = SdkHttpOperation.build<CreateInstanceRequest, CreateInstanceResponse> {
            serializeWith = CreateInstanceOperationSerializer()
            deserializeWith = CreateInstanceOperationDeserializer()
            operationName = "CreateInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     *
     * After a successful response, call `DescribeInstanceAccessControlAttributeConfiguration` to validate that `InstanceAccessControlAttributeConfiguration` was created.
     */
    override suspend fun createInstanceAccessControlAttributeConfiguration(input: CreateInstanceAccessControlAttributeConfigurationRequest): CreateInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<CreateInstanceAccessControlAttributeConfigurationRequest, CreateInstanceAccessControlAttributeConfigurationResponse> {
            serializeWith = CreateInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializeWith = CreateInstanceAccessControlAttributeConfigurationOperationDeserializer()
            operationName = "CreateInstanceAccessControlAttributeConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a permission set within a specified IAM Identity Center instance.
     *
     * To grant users and groups access to Amazon Web Services account resources, use ` <a>CreateAccountAssignment</a> `.
     */
    override suspend fun createPermissionSet(input: CreatePermissionSetRequest): CreatePermissionSetResponse {
        val op = SdkHttpOperation.build<CreatePermissionSetRequest, CreatePermissionSetResponse> {
            serializeWith = CreatePermissionSetOperationSerializer()
            deserializeWith = CreatePermissionSetOperationDeserializer()
            operationName = "CreatePermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a connection to a trusted token issuer in an instance of IAM Identity Center. A trusted token issuer enables trusted identity propagation to be used with applications that authenticate outside of Amazon Web Services.
     *
     * This trusted token issuer describes an external identity provider (IdP) that can generate claims or assertions in the form of access tokens for a user. Applications enabled for IAM Identity Center can use these tokens for authentication.
     */
    override suspend fun createTrustedTokenIssuer(input: CreateTrustedTokenIssuerRequest): CreateTrustedTokenIssuerResponse {
        val op = SdkHttpOperation.build<CreateTrustedTokenIssuerRequest, CreateTrustedTokenIssuerResponse> {
            serializeWith = CreateTrustedTokenIssuerOperationSerializer()
            deserializeWith = CreateTrustedTokenIssuerOperationDeserializer()
            operationName = "CreateTrustedTokenIssuer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.
     *
     * After a successful response, call `DescribeAccountAssignmentDeletionStatus` to describe the status of an assignment deletion request.
     */
    override suspend fun deleteAccountAssignment(input: DeleteAccountAssignmentRequest): DeleteAccountAssignmentResponse {
        val op = SdkHttpOperation.build<DeleteAccountAssignmentRequest, DeleteAccountAssignmentResponse> {
            serializeWith = DeleteAccountAssignmentOperationSerializer()
            deserializeWith = DeleteAccountAssignmentOperationDeserializer()
            operationName = "DeleteAccountAssignment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the association with the application. The connected service resource still exists.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializeWith = DeleteApplicationOperationSerializer()
            deserializeWith = DeleteApplicationOperationDeserializer()
            operationName = "DeleteApplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an IAM Identity Center access scope from an application.
     */
    override suspend fun deleteApplicationAccessScope(input: DeleteApplicationAccessScopeRequest): DeleteApplicationAccessScopeResponse {
        val op = SdkHttpOperation.build<DeleteApplicationAccessScopeRequest, DeleteApplicationAccessScopeResponse> {
            serializeWith = DeleteApplicationAccessScopeOperationSerializer()
            deserializeWith = DeleteApplicationAccessScopeOperationDeserializer()
            operationName = "DeleteApplicationAccessScope"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Revoke application access to an application by deleting application assignments for a user or group.
     */
    override suspend fun deleteApplicationAssignment(input: DeleteApplicationAssignmentRequest): DeleteApplicationAssignmentResponse {
        val op = SdkHttpOperation.build<DeleteApplicationAssignmentRequest, DeleteApplicationAssignmentResponse> {
            serializeWith = DeleteApplicationAssignmentOperationSerializer()
            deserializeWith = DeleteApplicationAssignmentOperationDeserializer()
            operationName = "DeleteApplicationAssignment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an authentication method from an application.
     */
    override suspend fun deleteApplicationAuthenticationMethod(input: DeleteApplicationAuthenticationMethodRequest): DeleteApplicationAuthenticationMethodResponse {
        val op = SdkHttpOperation.build<DeleteApplicationAuthenticationMethodRequest, DeleteApplicationAuthenticationMethodResponse> {
            serializeWith = DeleteApplicationAuthenticationMethodOperationSerializer()
            deserializeWith = DeleteApplicationAuthenticationMethodOperationDeserializer()
            operationName = "DeleteApplicationAuthenticationMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a grant from an application.
     */
    override suspend fun deleteApplicationGrant(input: DeleteApplicationGrantRequest): DeleteApplicationGrantResponse {
        val op = SdkHttpOperation.build<DeleteApplicationGrantRequest, DeleteApplicationGrantResponse> {
            serializeWith = DeleteApplicationGrantOperationSerializer()
            deserializeWith = DeleteApplicationGrantOperationDeserializer()
            operationName = "DeleteApplicationGrant"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the inline policy from a specified permission set.
     */
    override suspend fun deleteInlinePolicyFromPermissionSet(input: DeleteInlinePolicyFromPermissionSetRequest): DeleteInlinePolicyFromPermissionSetResponse {
        val op = SdkHttpOperation.build<DeleteInlinePolicyFromPermissionSetRequest, DeleteInlinePolicyFromPermissionSetResponse> {
            serializeWith = DeleteInlinePolicyFromPermissionSetOperationSerializer()
            deserializeWith = DeleteInlinePolicyFromPermissionSetOperationDeserializer()
            operationName = "DeleteInlinePolicyFromPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the instance of IAM Identity Center. Only the account that owns the instance can call this API. Neither the delegated administrator nor member account can delete the organization instance, but those roles can delete their own instance.
     */
    override suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse {
        val op = SdkHttpOperation.build<DeleteInstanceRequest, DeleteInstanceResponse> {
            serializeWith = DeleteInstanceOperationSerializer()
            deserializeWith = DeleteInstanceOperationDeserializer()
            operationName = "DeleteInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     */
    override suspend fun deleteInstanceAccessControlAttributeConfiguration(input: DeleteInstanceAccessControlAttributeConfigurationRequest): DeleteInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteInstanceAccessControlAttributeConfigurationRequest, DeleteInstanceAccessControlAttributeConfigurationResponse> {
            serializeWith = DeleteInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializeWith = DeleteInstanceAccessControlAttributeConfigurationOperationDeserializer()
            operationName = "DeleteInstanceAccessControlAttributeConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified permission set.
     */
    override suspend fun deletePermissionSet(input: DeletePermissionSetRequest): DeletePermissionSetResponse {
        val op = SdkHttpOperation.build<DeletePermissionSetRequest, DeletePermissionSetResponse> {
            serializeWith = DeletePermissionSetOperationSerializer()
            deserializeWith = DeletePermissionSetOperationDeserializer()
            operationName = "DeletePermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the permissions boundary from a specified PermissionSet.
     */
    override suspend fun deletePermissionsBoundaryFromPermissionSet(input: DeletePermissionsBoundaryFromPermissionSetRequest): DeletePermissionsBoundaryFromPermissionSetResponse {
        val op = SdkHttpOperation.build<DeletePermissionsBoundaryFromPermissionSetRequest, DeletePermissionsBoundaryFromPermissionSetResponse> {
            serializeWith = DeletePermissionsBoundaryFromPermissionSetOperationSerializer()
            deserializeWith = DeletePermissionsBoundaryFromPermissionSetOperationDeserializer()
            operationName = "DeletePermissionsBoundaryFromPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a trusted token issuer configuration from an instance of IAM Identity Center.
     *
     * Deleting this trusted token issuer configuration will cause users to lose access to any applications that are configured to use the trusted token issuer.
     */
    override suspend fun deleteTrustedTokenIssuer(input: DeleteTrustedTokenIssuerRequest): DeleteTrustedTokenIssuerResponse {
        val op = SdkHttpOperation.build<DeleteTrustedTokenIssuerRequest, DeleteTrustedTokenIssuerResponse> {
            serializeWith = DeleteTrustedTokenIssuerOperationSerializer()
            deserializeWith = DeleteTrustedTokenIssuerOperationDeserializer()
            operationName = "DeleteTrustedTokenIssuer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the assignment creation request.
     */
    override suspend fun describeAccountAssignmentCreationStatus(input: DescribeAccountAssignmentCreationStatusRequest): DescribeAccountAssignmentCreationStatusResponse {
        val op = SdkHttpOperation.build<DescribeAccountAssignmentCreationStatusRequest, DescribeAccountAssignmentCreationStatusResponse> {
            serializeWith = DescribeAccountAssignmentCreationStatusOperationSerializer()
            deserializeWith = DescribeAccountAssignmentCreationStatusOperationDeserializer()
            operationName = "DescribeAccountAssignmentCreationStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the assignment deletion request.
     */
    override suspend fun describeAccountAssignmentDeletionStatus(input: DescribeAccountAssignmentDeletionStatusRequest): DescribeAccountAssignmentDeletionStatusResponse {
        val op = SdkHttpOperation.build<DescribeAccountAssignmentDeletionStatusRequest, DescribeAccountAssignmentDeletionStatusResponse> {
            serializeWith = DescribeAccountAssignmentDeletionStatusOperationSerializer()
            deserializeWith = DescribeAccountAssignmentDeletionStatusOperationDeserializer()
            operationName = "DescribeAccountAssignmentDeletionStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of an application associated with an instance of IAM Identity Center.
     */
    override suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse {
        val op = SdkHttpOperation.build<DescribeApplicationRequest, DescribeApplicationResponse> {
            serializeWith = DescribeApplicationOperationSerializer()
            deserializeWith = DescribeApplicationOperationDeserializer()
            operationName = "DescribeApplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a direct assignment of a user or group to an application. If the user doesn’t have a direct assignment to the application, the user may still have access to the application through a group. Therefore, don’t use this API to test access to an application for a user. Instead use ListApplicationAssignmentsForPrincipal.
     */
    override suspend fun describeApplicationAssignment(input: DescribeApplicationAssignmentRequest): DescribeApplicationAssignmentResponse {
        val op = SdkHttpOperation.build<DescribeApplicationAssignmentRequest, DescribeApplicationAssignmentResponse> {
            serializeWith = DescribeApplicationAssignmentOperationSerializer()
            deserializeWith = DescribeApplicationAssignmentOperationDeserializer()
            operationName = "DescribeApplicationAssignment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details about a provider that can be used to connect an Amazon Web Services managed application or customer managed application to IAM Identity Center.
     */
    override suspend fun describeApplicationProvider(input: DescribeApplicationProviderRequest): DescribeApplicationProviderResponse {
        val op = SdkHttpOperation.build<DescribeApplicationProviderRequest, DescribeApplicationProviderResponse> {
            serializeWith = DescribeApplicationProviderOperationSerializer()
            deserializeWith = DescribeApplicationProviderOperationDeserializer()
            operationName = "DescribeApplicationProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details of an instance of IAM Identity Center. The status can be one of the following:
     * + `CREATE_IN_PROGRESS` - The instance is in the process of being created. When the instance is ready for use, DescribeInstance returns the status of `ACTIVE`. While the instance is in the `CREATE_IN_PROGRESS` state, you can call only DescribeInstance and DeleteInstance operations.
     * + `DELETE_IN_PROGRESS` - The instance is being deleted. Returns `AccessDeniedException` after the delete operation completes.
     * + `ACTIVE` - The instance is active.
     */
    override suspend fun describeInstance(input: DescribeInstanceRequest): DescribeInstanceResponse {
        val op = SdkHttpOperation.build<DescribeInstanceRequest, DescribeInstanceResponse> {
            serializeWith = DescribeInstanceOperationSerializer()
            deserializeWith = DescribeInstanceOperationDeserializer()
            operationName = "DescribeInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of IAM Identity Center identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     */
    override suspend fun describeInstanceAccessControlAttributeConfiguration(input: DescribeInstanceAccessControlAttributeConfigurationRequest): DescribeInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeInstanceAccessControlAttributeConfigurationRequest, DescribeInstanceAccessControlAttributeConfigurationResponse> {
            serializeWith = DescribeInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializeWith = DescribeInstanceAccessControlAttributeConfigurationOperationDeserializer()
            operationName = "DescribeInstanceAccessControlAttributeConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of the permission set.
     */
    override suspend fun describePermissionSet(input: DescribePermissionSetRequest): DescribePermissionSetResponse {
        val op = SdkHttpOperation.build<DescribePermissionSetRequest, DescribePermissionSetResponse> {
            serializeWith = DescribePermissionSetOperationSerializer()
            deserializeWith = DescribePermissionSetOperationDeserializer()
            operationName = "DescribePermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status for the given permission set provisioning request.
     */
    override suspend fun describePermissionSetProvisioningStatus(input: DescribePermissionSetProvisioningStatusRequest): DescribePermissionSetProvisioningStatusResponse {
        val op = SdkHttpOperation.build<DescribePermissionSetProvisioningStatusRequest, DescribePermissionSetProvisioningStatusResponse> {
            serializeWith = DescribePermissionSetProvisioningStatusOperationSerializer()
            deserializeWith = DescribePermissionSetProvisioningStatusOperationDeserializer()
            operationName = "DescribePermissionSetProvisioningStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details about a trusted token issuer configuration stored in an instance of IAM Identity Center. Details include the name of the trusted token issuer, the issuer URL, and the path of the source attribute and the destination attribute for a trusted token issuer configuration.
     */
    override suspend fun describeTrustedTokenIssuer(input: DescribeTrustedTokenIssuerRequest): DescribeTrustedTokenIssuerResponse {
        val op = SdkHttpOperation.build<DescribeTrustedTokenIssuerRequest, DescribeTrustedTokenIssuerResponse> {
            serializeWith = DescribeTrustedTokenIssuerOperationSerializer()
            deserializeWith = DescribeTrustedTokenIssuerOperationDeserializer()
            operationName = "DescribeTrustedTokenIssuer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches the specified customer managed policy from the specified PermissionSet.
     */
    override suspend fun detachCustomerManagedPolicyReferenceFromPermissionSet(input: DetachCustomerManagedPolicyReferenceFromPermissionSetRequest): DetachCustomerManagedPolicyReferenceFromPermissionSetResponse {
        val op = SdkHttpOperation.build<DetachCustomerManagedPolicyReferenceFromPermissionSetRequest, DetachCustomerManagedPolicyReferenceFromPermissionSetResponse> {
            serializeWith = DetachCustomerManagedPolicyReferenceFromPermissionSetOperationSerializer()
            deserializeWith = DetachCustomerManagedPolicyReferenceFromPermissionSetOperationDeserializer()
            operationName = "DetachCustomerManagedPolicyReferenceFromPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches the attached Amazon Web Services managed policy ARN from the specified permission set.
     */
    override suspend fun detachManagedPolicyFromPermissionSet(input: DetachManagedPolicyFromPermissionSetRequest): DetachManagedPolicyFromPermissionSetResponse {
        val op = SdkHttpOperation.build<DetachManagedPolicyFromPermissionSetRequest, DetachManagedPolicyFromPermissionSetResponse> {
            serializeWith = DetachManagedPolicyFromPermissionSetOperationSerializer()
            deserializeWith = DetachManagedPolicyFromPermissionSetOperationDeserializer()
            operationName = "DetachManagedPolicyFromPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the authorized targets for an IAM Identity Center access scope for an application.
     */
    override suspend fun getApplicationAccessScope(input: GetApplicationAccessScopeRequest): GetApplicationAccessScopeResponse {
        val op = SdkHttpOperation.build<GetApplicationAccessScopeRequest, GetApplicationAccessScopeResponse> {
            serializeWith = GetApplicationAccessScopeOperationSerializer()
            deserializeWith = GetApplicationAccessScopeOperationDeserializer()
            operationName = "GetApplicationAccessScope"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configuration of PutApplicationAssignmentConfiguration.
     */
    override suspend fun getApplicationAssignmentConfiguration(input: GetApplicationAssignmentConfigurationRequest): GetApplicationAssignmentConfigurationResponse {
        val op = SdkHttpOperation.build<GetApplicationAssignmentConfigurationRequest, GetApplicationAssignmentConfigurationResponse> {
            serializeWith = GetApplicationAssignmentConfigurationOperationSerializer()
            deserializeWith = GetApplicationAssignmentConfigurationOperationDeserializer()
            operationName = "GetApplicationAssignmentConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details about an authentication method used by an application.
     */
    override suspend fun getApplicationAuthenticationMethod(input: GetApplicationAuthenticationMethodRequest): GetApplicationAuthenticationMethodResponse {
        val op = SdkHttpOperation.build<GetApplicationAuthenticationMethodRequest, GetApplicationAuthenticationMethodResponse> {
            serializeWith = GetApplicationAuthenticationMethodOperationSerializer()
            deserializeWith = GetApplicationAuthenticationMethodOperationDeserializer()
            operationName = "GetApplicationAuthenticationMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details about an application grant.
     */
    override suspend fun getApplicationGrant(input: GetApplicationGrantRequest): GetApplicationGrantResponse {
        val op = SdkHttpOperation.build<GetApplicationGrantRequest, GetApplicationGrantResponse> {
            serializeWith = GetApplicationGrantOperationSerializer()
            deserializeWith = GetApplicationGrantOperationDeserializer()
            operationName = "GetApplicationGrant"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Obtains the inline policy assigned to the permission set.
     */
    override suspend fun getInlinePolicyForPermissionSet(input: GetInlinePolicyForPermissionSetRequest): GetInlinePolicyForPermissionSetResponse {
        val op = SdkHttpOperation.build<GetInlinePolicyForPermissionSetRequest, GetInlinePolicyForPermissionSetResponse> {
            serializeWith = GetInlinePolicyForPermissionSetOperationSerializer()
            deserializeWith = GetInlinePolicyForPermissionSetOperationDeserializer()
            operationName = "GetInlinePolicyForPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Obtains the permissions boundary for a specified PermissionSet.
     */
    override suspend fun getPermissionsBoundaryForPermissionSet(input: GetPermissionsBoundaryForPermissionSetRequest): GetPermissionsBoundaryForPermissionSetResponse {
        val op = SdkHttpOperation.build<GetPermissionsBoundaryForPermissionSetRequest, GetPermissionsBoundaryForPermissionSetResponse> {
            serializeWith = GetPermissionsBoundaryForPermissionSetOperationSerializer()
            deserializeWith = GetPermissionsBoundaryForPermissionSetOperationDeserializer()
            operationName = "GetPermissionsBoundaryForPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified IAM Identity Center instance.
     */
    override suspend fun listAccountAssignmentCreationStatus(input: ListAccountAssignmentCreationStatusRequest): ListAccountAssignmentCreationStatusResponse {
        val op = SdkHttpOperation.build<ListAccountAssignmentCreationStatusRequest, ListAccountAssignmentCreationStatusResponse> {
            serializeWith = ListAccountAssignmentCreationStatusOperationSerializer()
            deserializeWith = ListAccountAssignmentCreationStatusOperationDeserializer()
            operationName = "ListAccountAssignmentCreationStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified IAM Identity Center instance.
     */
    override suspend fun listAccountAssignmentDeletionStatus(input: ListAccountAssignmentDeletionStatusRequest): ListAccountAssignmentDeletionStatusResponse {
        val op = SdkHttpOperation.build<ListAccountAssignmentDeletionStatusRequest, ListAccountAssignmentDeletionStatusResponse> {
            serializeWith = ListAccountAssignmentDeletionStatusOperationSerializer()
            deserializeWith = ListAccountAssignmentDeletionStatusOperationDeserializer()
            operationName = "ListAccountAssignmentDeletionStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     */
    override suspend fun listAccountAssignments(input: ListAccountAssignmentsRequest): ListAccountAssignmentsResponse {
        val op = SdkHttpOperation.build<ListAccountAssignmentsRequest, ListAccountAssignmentsResponse> {
            serializeWith = ListAccountAssignmentsOperationSerializer()
            deserializeWith = ListAccountAssignmentsOperationDeserializer()
            operationName = "ListAccountAssignments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of the IAM Identity Center associated Amazon Web Services accounts that the principal has access to.
     */
    override suspend fun listAccountAssignmentsForPrincipal(input: ListAccountAssignmentsForPrincipalRequest): ListAccountAssignmentsForPrincipalResponse {
        val op = SdkHttpOperation.build<ListAccountAssignmentsForPrincipalRequest, ListAccountAssignmentsForPrincipalResponse> {
            serializeWith = ListAccountAssignmentsForPrincipalOperationSerializer()
            deserializeWith = ListAccountAssignmentsForPrincipalOperationDeserializer()
            operationName = "ListAccountAssignmentsForPrincipal"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     */
    override suspend fun listAccountsForProvisionedPermissionSet(input: ListAccountsForProvisionedPermissionSetRequest): ListAccountsForProvisionedPermissionSetResponse {
        val op = SdkHttpOperation.build<ListAccountsForProvisionedPermissionSetRequest, ListAccountsForProvisionedPermissionSetResponse> {
            serializeWith = ListAccountsForProvisionedPermissionSetOperationSerializer()
            deserializeWith = ListAccountsForProvisionedPermissionSetOperationDeserializer()
            operationName = "ListAccountsForProvisionedPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the access scopes and authorized targets associated with an application.
     */
    override suspend fun listApplicationAccessScopes(input: ListApplicationAccessScopesRequest): ListApplicationAccessScopesResponse {
        val op = SdkHttpOperation.build<ListApplicationAccessScopesRequest, ListApplicationAccessScopesResponse> {
            serializeWith = ListApplicationAccessScopesOperationSerializer()
            deserializeWith = ListApplicationAccessScopesOperationDeserializer()
            operationName = "ListApplicationAccessScopes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon Web Services account users that are assigned to an application.
     */
    override suspend fun listApplicationAssignments(input: ListApplicationAssignmentsRequest): ListApplicationAssignmentsResponse {
        val op = SdkHttpOperation.build<ListApplicationAssignmentsRequest, ListApplicationAssignmentsResponse> {
            serializeWith = ListApplicationAssignmentsOperationSerializer()
            deserializeWith = ListApplicationAssignmentsOperationDeserializer()
            operationName = "ListApplicationAssignments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the applications to which a specified principal is assigned.
     */
    override suspend fun listApplicationAssignmentsForPrincipal(input: ListApplicationAssignmentsForPrincipalRequest): ListApplicationAssignmentsForPrincipalResponse {
        val op = SdkHttpOperation.build<ListApplicationAssignmentsForPrincipalRequest, ListApplicationAssignmentsForPrincipalResponse> {
            serializeWith = ListApplicationAssignmentsForPrincipalOperationSerializer()
            deserializeWith = ListApplicationAssignmentsForPrincipalOperationDeserializer()
            operationName = "ListApplicationAssignmentsForPrincipal"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the authentication methods supported by the specified application.
     */
    override suspend fun listApplicationAuthenticationMethods(input: ListApplicationAuthenticationMethodsRequest): ListApplicationAuthenticationMethodsResponse {
        val op = SdkHttpOperation.build<ListApplicationAuthenticationMethodsRequest, ListApplicationAuthenticationMethodsResponse> {
            serializeWith = ListApplicationAuthenticationMethodsOperationSerializer()
            deserializeWith = ListApplicationAuthenticationMethodsOperationDeserializer()
            operationName = "ListApplicationAuthenticationMethods"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List the grants associated with an application.
     */
    override suspend fun listApplicationGrants(input: ListApplicationGrantsRequest): ListApplicationGrantsResponse {
        val op = SdkHttpOperation.build<ListApplicationGrantsRequest, ListApplicationGrantsResponse> {
            serializeWith = ListApplicationGrantsOperationSerializer()
            deserializeWith = ListApplicationGrantsOperationDeserializer()
            operationName = "ListApplicationGrants"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the application providers configured in the IAM Identity Center identity store.
     */
    override suspend fun listApplicationProviders(input: ListApplicationProvidersRequest): ListApplicationProvidersResponse {
        val op = SdkHttpOperation.build<ListApplicationProvidersRequest, ListApplicationProvidersResponse> {
            serializeWith = ListApplicationProvidersOperationSerializer()
            deserializeWith = ListApplicationProvidersOperationDeserializer()
            operationName = "ListApplicationProviders"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all applications associated with the instance of IAM Identity Center. When listing applications for an instance in the management account, member accounts must use the `applicationAccount` parameter to filter the list to only applications created from that account.
     */
    override suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse {
        val op = SdkHttpOperation.build<ListApplicationsRequest, ListApplicationsResponse> {
            serializeWith = ListApplicationsOperationSerializer()
            deserializeWith = ListApplicationsOperationDeserializer()
            operationName = "ListApplications"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all customer managed policies attached to a specified PermissionSet.
     */
    override suspend fun listCustomerManagedPolicyReferencesInPermissionSet(input: ListCustomerManagedPolicyReferencesInPermissionSetRequest): ListCustomerManagedPolicyReferencesInPermissionSetResponse {
        val op = SdkHttpOperation.build<ListCustomerManagedPolicyReferencesInPermissionSetRequest, ListCustomerManagedPolicyReferencesInPermissionSetResponse> {
            serializeWith = ListCustomerManagedPolicyReferencesInPermissionSetOperationSerializer()
            deserializeWith = ListCustomerManagedPolicyReferencesInPermissionSetOperationDeserializer()
            operationName = "ListCustomerManagedPolicyReferencesInPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the details of the organization and account instances of IAM Identity Center that were created in or visible to the account calling this API.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializeWith = ListInstancesOperationSerializer()
            deserializeWith = ListInstancesOperationDeserializer()
            operationName = "ListInstances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon Web Services managed policy that is attached to a specified permission set.
     */
    override suspend fun listManagedPoliciesInPermissionSet(input: ListManagedPoliciesInPermissionSetRequest): ListManagedPoliciesInPermissionSetResponse {
        val op = SdkHttpOperation.build<ListManagedPoliciesInPermissionSetRequest, ListManagedPoliciesInPermissionSetResponse> {
            serializeWith = ListManagedPoliciesInPermissionSetOperationSerializer()
            deserializeWith = ListManagedPoliciesInPermissionSetOperationDeserializer()
            operationName = "ListManagedPoliciesInPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     */
    override suspend fun listPermissionSetProvisioningStatus(input: ListPermissionSetProvisioningStatusRequest): ListPermissionSetProvisioningStatusResponse {
        val op = SdkHttpOperation.build<ListPermissionSetProvisioningStatusRequest, ListPermissionSetProvisioningStatusResponse> {
            serializeWith = ListPermissionSetProvisioningStatusOperationSerializer()
            deserializeWith = ListPermissionSetProvisioningStatusOperationDeserializer()
            operationName = "ListPermissionSetProvisioningStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the PermissionSets in an IAM Identity Center instance.
     */
    override suspend fun listPermissionSets(input: ListPermissionSetsRequest): ListPermissionSetsResponse {
        val op = SdkHttpOperation.build<ListPermissionSetsRequest, ListPermissionSetsResponse> {
            serializeWith = ListPermissionSetsOperationSerializer()
            deserializeWith = ListPermissionSetsOperationDeserializer()
            operationName = "ListPermissionSets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     */
    override suspend fun listPermissionSetsProvisionedToAccount(input: ListPermissionSetsProvisionedToAccountRequest): ListPermissionSetsProvisionedToAccountResponse {
        val op = SdkHttpOperation.build<ListPermissionSetsProvisionedToAccountRequest, ListPermissionSetsProvisionedToAccountResponse> {
            serializeWith = ListPermissionSetsProvisionedToAccountOperationSerializer()
            deserializeWith = ListPermissionSetsProvisionedToAccountOperationDeserializer()
            operationName = "ListPermissionSetsProvisionedToAccount"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags that are attached to a specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the trusted token issuers configured in an instance of IAM Identity Center.
     */
    override suspend fun listTrustedTokenIssuers(input: ListTrustedTokenIssuersRequest): ListTrustedTokenIssuersResponse {
        val op = SdkHttpOperation.build<ListTrustedTokenIssuersRequest, ListTrustedTokenIssuersResponse> {
            serializeWith = ListTrustedTokenIssuersOperationSerializer()
            deserializeWith = ListTrustedTokenIssuersOperationDeserializer()
            operationName = "ListTrustedTokenIssuers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * The process by which a specified permission set is provisioned to the specified target.
     */
    override suspend fun provisionPermissionSet(input: ProvisionPermissionSetRequest): ProvisionPermissionSetResponse {
        val op = SdkHttpOperation.build<ProvisionPermissionSetRequest, ProvisionPermissionSetResponse> {
            serializeWith = ProvisionPermissionSetOperationSerializer()
            deserializeWith = ProvisionPermissionSetOperationDeserializer()
            operationName = "ProvisionPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates the list of authorized targets for an IAM Identity Center access scope for an application.
     */
    override suspend fun putApplicationAccessScope(input: PutApplicationAccessScopeRequest): PutApplicationAccessScopeResponse {
        val op = SdkHttpOperation.build<PutApplicationAccessScopeRequest, PutApplicationAccessScopeResponse> {
            serializeWith = PutApplicationAccessScopeOperationSerializer()
            deserializeWith = PutApplicationAccessScopeOperationDeserializer()
            operationName = "PutApplicationAccessScope"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Configure how users gain access to an application. If `AssignmentsRequired` is `true` (default value), users don’t have access to the application unless an assignment is created using the [CreateApplicationAssignment API](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html). If `false`, all users have access to the application. If an assignment is created using [CreateApplicationAssignment](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html)., the user retains access if `AssignmentsRequired` is set to `true`.
     */
    override suspend fun putApplicationAssignmentConfiguration(input: PutApplicationAssignmentConfigurationRequest): PutApplicationAssignmentConfigurationResponse {
        val op = SdkHttpOperation.build<PutApplicationAssignmentConfigurationRequest, PutApplicationAssignmentConfigurationResponse> {
            serializeWith = PutApplicationAssignmentConfigurationOperationSerializer()
            deserializeWith = PutApplicationAssignmentConfigurationOperationDeserializer()
            operationName = "PutApplicationAssignmentConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates an authentication method for an application.
     */
    override suspend fun putApplicationAuthenticationMethod(input: PutApplicationAuthenticationMethodRequest): PutApplicationAuthenticationMethodResponse {
        val op = SdkHttpOperation.build<PutApplicationAuthenticationMethodRequest, PutApplicationAuthenticationMethodResponse> {
            serializeWith = PutApplicationAuthenticationMethodOperationSerializer()
            deserializeWith = PutApplicationAuthenticationMethodOperationDeserializer()
            operationName = "PutApplicationAuthenticationMethod"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a grant to an application.
     */
    override suspend fun putApplicationGrant(input: PutApplicationGrantRequest): PutApplicationGrantResponse {
        val op = SdkHttpOperation.build<PutApplicationGrantRequest, PutApplicationGrantResponse> {
            serializeWith = PutApplicationGrantOperationSerializer()
            deserializeWith = PutApplicationGrantOperationDeserializer()
            operationName = "PutApplicationGrant"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an inline policy to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this action to apply the corresponding IAM policy updates to all assigned accounts.
     */
    override suspend fun putInlinePolicyToPermissionSet(input: PutInlinePolicyToPermissionSetRequest): PutInlinePolicyToPermissionSetResponse {
        val op = SdkHttpOperation.build<PutInlinePolicyToPermissionSetRequest, PutInlinePolicyToPermissionSetResponse> {
            serializeWith = PutInlinePolicyToPermissionSetOperationSerializer()
            deserializeWith = PutInlinePolicyToPermissionSetOperationDeserializer()
            operationName = "PutInlinePolicyToPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an Amazon Web Services managed or customer managed policy to the specified PermissionSet as a permissions boundary.
     */
    override suspend fun putPermissionsBoundaryToPermissionSet(input: PutPermissionsBoundaryToPermissionSetRequest): PutPermissionsBoundaryToPermissionSetResponse {
        val op = SdkHttpOperation.build<PutPermissionsBoundaryToPermissionSetRequest, PutPermissionsBoundaryToPermissionSetResponse> {
            serializeWith = PutPermissionsBoundaryToPermissionSetOperationSerializer()
            deserializeWith = PutPermissionsBoundaryToPermissionSetOperationDeserializer()
            operationName = "PutPermissionsBoundaryToPermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a set of tags with a specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a set of tags from a specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates application properties.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializeWith = UpdateApplicationOperationSerializer()
            deserializeWith = UpdateApplicationOperationDeserializer()
            operationName = "UpdateApplication"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Update the details for the instance of IAM Identity Center that is owned by the Amazon Web Services account.
     */
    override suspend fun updateInstance(input: UpdateInstanceRequest): UpdateInstanceResponse {
        val op = SdkHttpOperation.build<UpdateInstanceRequest, UpdateInstanceResponse> {
            serializeWith = UpdateInstanceOperationSerializer()
            deserializeWith = UpdateInstanceOperationDeserializer()
            operationName = "UpdateInstance"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     */
    override suspend fun updateInstanceAccessControlAttributeConfiguration(input: UpdateInstanceAccessControlAttributeConfigurationRequest): UpdateInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateInstanceAccessControlAttributeConfigurationRequest, UpdateInstanceAccessControlAttributeConfigurationResponse> {
            serializeWith = UpdateInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializeWith = UpdateInstanceAccessControlAttributeConfigurationOperationDeserializer()
            operationName = "UpdateInstanceAccessControlAttributeConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing permission set.
     */
    override suspend fun updatePermissionSet(input: UpdatePermissionSetRequest): UpdatePermissionSetResponse {
        val op = SdkHttpOperation.build<UpdatePermissionSetRequest, UpdatePermissionSetResponse> {
            serializeWith = UpdatePermissionSetOperationSerializer()
            deserializeWith = UpdatePermissionSetOperationDeserializer()
            operationName = "UpdatePermissionSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of the trusted token issuer, or the path of a source attribute or destination attribute for a trusted token issuer configuration.
     *
     * Updating this trusted token issuer configuration might cause users to lose access to any applications that are configured to use the trusted token issuer.
     */
    override suspend fun updateTrustedTokenIssuer(input: UpdateTrustedTokenIssuerRequest): UpdateTrustedTokenIssuerResponse {
        val op = SdkHttpOperation.build<UpdateTrustedTokenIssuerRequest, UpdateTrustedTokenIssuerResponse> {
            serializeWith = UpdateTrustedTokenIssuerOperationSerializer()
            deserializeWith = UpdateTrustedTokenIssuerOperationDeserializer()
            operationName = "UpdateTrustedTokenIssuer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "sso")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
