// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssoadmin.model.CreatePermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.PermissionSet
import aws.sdk.kotlin.services.ssoadmin.model.SsoAdminException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePermissionSetOperationDeserializer: HttpDeserialize<CreatePermissionSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePermissionSetResponse {
        if (!response.status.isSuccess()) {
            throwCreatePermissionSetError(context, response)
        }
        val builder = CreatePermissionSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePermissionSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreatePermissionSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsoAdminException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsoAdminException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePermissionSetOperationBody(builder: CreatePermissionSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PERMISSIONSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PermissionSet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PERMISSIONSET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PERMISSIONSET_DESCRIPTOR.index -> builder.permissionSet = deserializePermissionSetDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
