// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ssoadmin.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ssoadmin.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services Single Sign On (SSO) is a cloud SSO service that makes it easy to centrally manage SSO access to multiple Amazon Web Services accounts and business applications. This guide provides information on SSO operations which could be used for access management of Amazon Web Services accounts. For information about Amazon Web Services SSO features, see the [Amazon Web Services Single Sign-On User Guide](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html).
 *
 * Many operations in the SSO APIs rely on identifiers for users and groups, known as principals. For more information about how to work with principals and principal IDs in Amazon Web Services SSO, see the [Amazon Web Services SSO Identity Store API Reference](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
 */
interface SsoAdminClient : SdkClient {

    override val serviceName: String
        get() = "SSO Admin"
    /**
     * SsoAdminClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): SsoAdminClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSsoAdminClient(config)
        }

        operator fun invoke(config: Config): SsoAdminClient = DefaultSsoAdminClient(config)

        /**
         * Construct a [SsoAdminClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SsoAdminClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultSsoAdminClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Attaches an IAM managed policy ARN to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this operation. Calling `ProvisionPermissionSet` applies the corresponding IAM policy updates to all assigned accounts.
     */
    suspend fun attachManagedPolicyToPermissionSet(input: AttachManagedPolicyToPermissionSetRequest): AttachManagedPolicyToPermissionSetResponse

    /**
     * Attaches an IAM managed policy ARN to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this operation. Calling `ProvisionPermissionSet` applies the corresponding IAM policy updates to all assigned accounts.
     */
    suspend fun attachManagedPolicyToPermissionSet(block: AttachManagedPolicyToPermissionSetRequest.Builder.() -> Unit) = attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest.Builder().apply(block).build())

    /**
     * Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.
     *
     * The term *principal* here refers to a user or group that is defined in Amazon Web Services SSO.
     *
     * As part of a successful `CreateAccountAssignment` call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the SSO-created IAM role. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call ` <a>ProvisionPermissionSet</a> ` to make these updates.
     */
    suspend fun createAccountAssignment(input: CreateAccountAssignmentRequest): CreateAccountAssignmentResponse

    /**
     * Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.
     *
     * The term *principal* here refers to a user or group that is defined in Amazon Web Services SSO.
     *
     * As part of a successful `CreateAccountAssignment` call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the SSO-created IAM role. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call ` <a>ProvisionPermissionSet</a> ` to make these updates.
     */
    suspend fun createAccountAssignment(block: CreateAccountAssignmentRequest.Builder.() -> Unit) = createAccountAssignment(CreateAccountAssignmentRequest.Builder().apply(block).build())

    /**
     * Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun createInstanceAccessControlAttributeConfiguration(input: CreateInstanceAccessControlAttributeConfigurationRequest): CreateInstanceAccessControlAttributeConfigurationResponse

    /**
     * Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun createInstanceAccessControlAttributeConfiguration(block: CreateInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit) = createInstanceAccessControlAttributeConfiguration(CreateInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates a permission set within a specified SSO instance.
     *
     * To grant users and groups access to Amazon Web Services account resources, use ` <a>CreateAccountAssignment</a> `.
     */
    suspend fun createPermissionSet(input: CreatePermissionSetRequest): CreatePermissionSetResponse

    /**
     * Creates a permission set within a specified SSO instance.
     *
     * To grant users and groups access to Amazon Web Services account resources, use ` <a>CreateAccountAssignment</a> `.
     */
    suspend fun createPermissionSet(block: CreatePermissionSetRequest.Builder.() -> Unit) = createPermissionSet(CreatePermissionSetRequest.Builder().apply(block).build())

    /**
     * Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.
     */
    suspend fun deleteAccountAssignment(input: DeleteAccountAssignmentRequest): DeleteAccountAssignmentResponse

    /**
     * Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.
     */
    suspend fun deleteAccountAssignment(block: DeleteAccountAssignmentRequest.Builder.() -> Unit) = deleteAccountAssignment(DeleteAccountAssignmentRequest.Builder().apply(block).build())

    /**
     * Deletes the inline policy from a specified permission set.
     */
    suspend fun deleteInlinePolicyFromPermissionSet(input: DeleteInlinePolicyFromPermissionSetRequest): DeleteInlinePolicyFromPermissionSetResponse

    /**
     * Deletes the inline policy from a specified permission set.
     */
    suspend fun deleteInlinePolicyFromPermissionSet(block: DeleteInlinePolicyFromPermissionSetRequest.Builder.() -> Unit) = deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest.Builder().apply(block).build())

    /**
     * Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun deleteInstanceAccessControlAttributeConfiguration(input: DeleteInstanceAccessControlAttributeConfigurationRequest): DeleteInstanceAccessControlAttributeConfigurationResponse

    /**
     * Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun deleteInstanceAccessControlAttributeConfiguration(block: DeleteInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit) = deleteInstanceAccessControlAttributeConfiguration(DeleteInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes the specified permission set.
     */
    suspend fun deletePermissionSet(input: DeletePermissionSetRequest): DeletePermissionSetResponse

    /**
     * Deletes the specified permission set.
     */
    suspend fun deletePermissionSet(block: DeletePermissionSetRequest.Builder.() -> Unit) = deletePermissionSet(DeletePermissionSetRequest.Builder().apply(block).build())

    /**
     * Describes the status of the assignment creation request.
     */
    suspend fun describeAccountAssignmentCreationStatus(input: DescribeAccountAssignmentCreationStatusRequest): DescribeAccountAssignmentCreationStatusResponse

    /**
     * Describes the status of the assignment creation request.
     */
    suspend fun describeAccountAssignmentCreationStatus(block: DescribeAccountAssignmentCreationStatusRequest.Builder.() -> Unit) = describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest.Builder().apply(block).build())

    /**
     * Describes the status of the assignment deletion request.
     */
    suspend fun describeAccountAssignmentDeletionStatus(input: DescribeAccountAssignmentDeletionStatusRequest): DescribeAccountAssignmentDeletionStatusResponse

    /**
     * Describes the status of the assignment deletion request.
     */
    suspend fun describeAccountAssignmentDeletionStatus(block: DescribeAccountAssignmentDeletionStatusRequest.Builder.() -> Unit) = describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest.Builder().apply(block).build())

    /**
     * Returns the list of Amazon Web Services SSO identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun describeInstanceAccessControlAttributeConfiguration(input: DescribeInstanceAccessControlAttributeConfigurationRequest): DescribeInstanceAccessControlAttributeConfigurationResponse

    /**
     * Returns the list of Amazon Web Services SSO identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun describeInstanceAccessControlAttributeConfiguration(block: DescribeInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit) = describeInstanceAccessControlAttributeConfiguration(DescribeInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

    /**
     * Gets the details of the permission set.
     */
    suspend fun describePermissionSet(input: DescribePermissionSetRequest): DescribePermissionSetResponse

    /**
     * Gets the details of the permission set.
     */
    suspend fun describePermissionSet(block: DescribePermissionSetRequest.Builder.() -> Unit) = describePermissionSet(DescribePermissionSetRequest.Builder().apply(block).build())

    /**
     * Describes the status for the given permission set provisioning request.
     */
    suspend fun describePermissionSetProvisioningStatus(input: DescribePermissionSetProvisioningStatusRequest): DescribePermissionSetProvisioningStatusResponse

    /**
     * Describes the status for the given permission set provisioning request.
     */
    suspend fun describePermissionSetProvisioningStatus(block: DescribePermissionSetProvisioningStatusRequest.Builder.() -> Unit) = describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest.Builder().apply(block).build())

    /**
     * Detaches the attached IAM managed policy ARN from the specified permission set.
     */
    suspend fun detachManagedPolicyFromPermissionSet(input: DetachManagedPolicyFromPermissionSetRequest): DetachManagedPolicyFromPermissionSetResponse

    /**
     * Detaches the attached IAM managed policy ARN from the specified permission set.
     */
    suspend fun detachManagedPolicyFromPermissionSet(block: DetachManagedPolicyFromPermissionSetRequest.Builder.() -> Unit) = detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest.Builder().apply(block).build())

    /**
     * Obtains the inline policy assigned to the permission set.
     */
    suspend fun getInlinePolicyForPermissionSet(input: GetInlinePolicyForPermissionSetRequest): GetInlinePolicyForPermissionSetResponse

    /**
     * Obtains the inline policy assigned to the permission set.
     */
    suspend fun getInlinePolicyForPermissionSet(block: GetInlinePolicyForPermissionSetRequest.Builder.() -> Unit) = getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest.Builder().apply(block).build())

    /**
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified SSO instance.
     */
    suspend fun listAccountAssignmentCreationStatus(input: ListAccountAssignmentCreationStatusRequest): ListAccountAssignmentCreationStatusResponse

    /**
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified SSO instance.
     */
    suspend fun listAccountAssignmentCreationStatus(block: ListAccountAssignmentCreationStatusRequest.Builder.() -> Unit) = listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest.Builder().apply(block).build())

    /**
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified SSO instance.
     */
    suspend fun listAccountAssignmentDeletionStatus(input: ListAccountAssignmentDeletionStatusRequest): ListAccountAssignmentDeletionStatusResponse

    /**
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified SSO instance.
     */
    suspend fun listAccountAssignmentDeletionStatus(block: ListAccountAssignmentDeletionStatusRequest.Builder.() -> Unit) = listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest.Builder().apply(block).build())

    /**
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     */
    suspend fun listAccountAssignments(input: ListAccountAssignmentsRequest): ListAccountAssignmentsResponse

    /**
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     */
    suspend fun listAccountAssignments(block: ListAccountAssignmentsRequest.Builder.() -> Unit) = listAccountAssignments(ListAccountAssignmentsRequest.Builder().apply(block).build())

    /**
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     */
    suspend fun listAccountsForProvisionedPermissionSet(input: ListAccountsForProvisionedPermissionSetRequest): ListAccountsForProvisionedPermissionSetResponse

    /**
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     */
    suspend fun listAccountsForProvisionedPermissionSet(block: ListAccountsForProvisionedPermissionSetRequest.Builder.() -> Unit) = listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest.Builder().apply(block).build())

    /**
     * Lists the SSO instances that the caller has access to.
     */
    suspend fun listInstances(input: ListInstancesRequest = ListInstancesRequest {}): ListInstancesResponse

    /**
     * Lists the SSO instances that the caller has access to.
     */
    suspend fun listInstances(block: ListInstancesRequest.Builder.() -> Unit) = listInstances(ListInstancesRequest.Builder().apply(block).build())

    /**
     * Lists the IAM managed policy that is attached to a specified permission set.
     */
    suspend fun listManagedPoliciesInPermissionSet(input: ListManagedPoliciesInPermissionSetRequest): ListManagedPoliciesInPermissionSetResponse

    /**
     * Lists the IAM managed policy that is attached to a specified permission set.
     */
    suspend fun listManagedPoliciesInPermissionSet(block: ListManagedPoliciesInPermissionSetRequest.Builder.() -> Unit) = listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest.Builder().apply(block).build())

    /**
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     */
    suspend fun listPermissionSetProvisioningStatus(input: ListPermissionSetProvisioningStatusRequest): ListPermissionSetProvisioningStatusResponse

    /**
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     */
    suspend fun listPermissionSetProvisioningStatus(block: ListPermissionSetProvisioningStatusRequest.Builder.() -> Unit) = listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest.Builder().apply(block).build())

    /**
     * Lists the PermissionSets in an SSO instance.
     */
    suspend fun listPermissionSets(input: ListPermissionSetsRequest): ListPermissionSetsResponse

    /**
     * Lists the PermissionSets in an SSO instance.
     */
    suspend fun listPermissionSets(block: ListPermissionSetsRequest.Builder.() -> Unit) = listPermissionSets(ListPermissionSetsRequest.Builder().apply(block).build())

    /**
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     */
    suspend fun listPermissionSetsProvisionedToAccount(input: ListPermissionSetsProvisionedToAccountRequest): ListPermissionSetsProvisionedToAccountResponse

    /**
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     */
    suspend fun listPermissionSetsProvisionedToAccount(block: ListPermissionSetsProvisionedToAccountRequest.Builder.() -> Unit) = listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest.Builder().apply(block).build())

    /**
     * Lists the tags that are attached to a specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags that are attached to a specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * The process by which a specified permission set is provisioned to the specified target.
     */
    suspend fun provisionPermissionSet(input: ProvisionPermissionSetRequest): ProvisionPermissionSetResponse

    /**
     * The process by which a specified permission set is provisioned to the specified target.
     */
    suspend fun provisionPermissionSet(block: ProvisionPermissionSetRequest.Builder.() -> Unit) = provisionPermissionSet(ProvisionPermissionSetRequest.Builder().apply(block).build())

    /**
     * Attaches an IAM inline policy to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this action to apply the corresponding IAM policy updates to all assigned accounts.
     */
    suspend fun putInlinePolicyToPermissionSet(input: PutInlinePolicyToPermissionSetRequest): PutInlinePolicyToPermissionSetResponse

    /**
     * Attaches an IAM inline policy to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this action to apply the corresponding IAM policy updates to all assigned accounts.
     */
    suspend fun putInlinePolicyToPermissionSet(block: PutInlinePolicyToPermissionSetRequest.Builder.() -> Unit) = putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest.Builder().apply(block).build())

    /**
     * Associates a set of tags with a specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates a set of tags with a specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Disassociates a set of tags from a specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Disassociates a set of tags from a specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO replaces the attribute value with the value from the Amazon Web Services SSO identity store. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun updateInstanceAccessControlAttributeConfiguration(input: UpdateInstanceAccessControlAttributeConfigurationRequest): UpdateInstanceAccessControlAttributeConfigurationResponse

    /**
     * Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO replaces the attribute value with the value from the Amazon Web Services SSO identity store. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    suspend fun updateInstanceAccessControlAttributeConfiguration(block: UpdateInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit) = updateInstanceAccessControlAttributeConfiguration(UpdateInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates an existing permission set.
     */
    suspend fun updatePermissionSet(input: UpdatePermissionSetRequest): UpdatePermissionSetResponse

    /**
     * Updates an existing permission set.
     */
    suspend fun updatePermissionSet(block: UpdatePermissionSetRequest.Builder.() -> Unit) = updatePermissionSet(UpdatePermissionSetRequest.Builder().apply(block).build())
}
