// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sso.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides information about the role credentials that are assigned to the user.
 */
public class RoleCredentials private constructor(builder: Builder) {
    /**
     * The identifier used for the temporary security credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The date on which temporary security credentials expire.
     */
    public val expiration: kotlin.Long = builder.expiration
    /**
     * The key that is used to sign the request. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
     */
    public val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * The token used for temporary credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
     */
    public val sessionToken: kotlin.String? = builder.sessionToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sso.model.RoleCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoleCredentials(")
        append("accessKeyId=$accessKeyId,")
        append("expiration=$expiration,")
        append("secretAccessKey=*** Sensitive Data Redacted ***,")
        append("sessionToken=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (this.expiration.hashCode())
        result = 31 * result + (this.secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (this.sessionToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoleCredentials

        if (accessKeyId != other.accessKeyId) return false
        if (expiration != other.expiration) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sso.model.RoleCredentials = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier used for the temporary security credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * The date on which temporary security credentials expire.
         */
        public var expiration: kotlin.Long = 0L
        /**
         * The key that is used to sign the request. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * The token used for temporary credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sso.model.RoleCredentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.expiration = x.expiration
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sso.model.RoleCredentials = RoleCredentials(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
