// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.waiters

import aws.sdk.kotlin.services.ssmincidents.SsmIncidentsClient
import aws.sdk.kotlin.services.ssmincidents.model.GetReplicationSetRequest
import aws.sdk.kotlin.services.ssmincidents.model.GetReplicationSetResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait for a replication set to become ACTIVE
 */
public suspend fun SsmIncidentsClient.waitForReplicationSetActive(request: GetReplicationSetRequest): Outcome<GetReplicationSetResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 30_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetReplicationSetRequest, GetReplicationSetResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val replicationSet = it.replicationSet
            val status = replicationSet?.status?.value
            status == "ACTIVE"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val replicationSet = it.replicationSet
            val status = replicationSet?.status?.value
            status == "CREATING"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val replicationSet = it.replicationSet
            val status = replicationSet?.status?.value
            status == "UPDATING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationSet = it.replicationSet
            val status = replicationSet?.status?.value
            status == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getReplicationSet(request) }
}

/**
 * Wait for a replication set to become ACTIVE
 */
public suspend fun SsmIncidentsClient.waitForReplicationSetActive(block: GetReplicationSetRequest.Builder.() -> Unit): Outcome<GetReplicationSetResponse> =
    waitForReplicationSetActive(GetReplicationSetRequest.Builder().apply(block).build())

/**
 * Wait for a replication set to be deleted
 */
public suspend fun SsmIncidentsClient.waitForReplicationSetDeleted(request: GetReplicationSetRequest): Outcome<GetReplicationSetResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 30_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetReplicationSetRequest, GetReplicationSetResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val replicationSet = it.replicationSet
            val status = replicationSet?.status?.value
            status == "DELETING"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val replicationSet = it.replicationSet
            val status = replicationSet?.status?.value
            status == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getReplicationSet(request) }
}

/**
 * Wait for a replication set to be deleted
 */
public suspend fun SsmIncidentsClient.waitForReplicationSetDeleted(block: GetReplicationSetRequest.Builder.() -> Unit): Outcome<GetReplicationSetResponse> =
    waitForReplicationSetDeleted(GetReplicationSetRequest.Builder().apply(block).build())
