// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.transform

import aws.sdk.kotlin.services.ssmincidents.model.Action
import aws.sdk.kotlin.services.ssmincidents.model.ChatChannel
import aws.sdk.kotlin.services.ssmincidents.model.GetResponsePlanResponse
import aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate
import aws.sdk.kotlin.services.ssmincidents.model.Integration
import aws.sdk.kotlin.services.ssmincidents.model.SsmIncidentsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetResponsePlanOperationDeserializer: HttpDeserialize<GetResponsePlanResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetResponsePlanResponse {
        if (!response.status.isSuccess()) {
            throwGetResponsePlanError(context, response)
        }
        val builder = GetResponsePlanResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetResponsePlanOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetResponsePlanError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmIncidentsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmIncidentsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetResponsePlanOperationBody(builder: GetResponsePlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actions"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CHATCHANNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("chatChannel"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val ENGAGEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("engagements"))
    val INCIDENTTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("incidentTemplate"))
    val INTEGRATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("integrations"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CHATCHANNEL_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(ENGAGEMENTS_DESCRIPTOR)
        field(INCIDENTTEMPLATE_DESCRIPTOR)
        field(INTEGRATIONS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONS_DESCRIPTOR.index -> builder.actions =
                    deserializer.deserializeList(ACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Action>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CHATCHANNEL_DESCRIPTOR.index -> builder.chatChannel = deserializeChatChannelDocument(deserializer)
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                ENGAGEMENTS_DESCRIPTOR.index -> builder.engagements =
                    deserializer.deserializeList(ENGAGEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INCIDENTTEMPLATE_DESCRIPTOR.index -> builder.incidentTemplate = deserializeIncidentTemplateDocument(deserializer)
                INTEGRATIONS_DESCRIPTOR.index -> builder.integrations =
                    deserializer.deserializeList(INTEGRATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Integration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIntegrationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
