// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.transform

import aws.sdk.kotlin.services.ssmincidents.model.CreateTimelineEventRequest
import aws.sdk.kotlin.services.ssmincidents.model.EventReference
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateTimelineEventOperationSerializer: HttpSerialize<CreateTimelineEventRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateTimelineEventRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/createTimelineEvent"
        }

        val payload = serializeCreateTimelineEventOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateTimelineEventOperationBody(context: ExecutionContext, input: CreateTimelineEventRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val EVENTDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("eventData"))
    val EVENTREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("eventReferences"))
    val EVENTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("eventTime"))
    val EVENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("eventType"))
    val INCIDENTRECORDARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("incidentRecordArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(EVENTDATA_DESCRIPTOR)
        field(EVENTREFERENCES_DESCRIPTOR)
        field(EVENTTIME_DESCRIPTOR)
        field(EVENTTYPE_DESCRIPTOR)
        field(INCIDENTRECORDARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.eventData?.let { field(EVENTDATA_DESCRIPTOR, it) }
        if (input.eventReferences != null) {
            listField(EVENTREFERENCES_DESCRIPTOR) {
                for (el0 in input.eventReferences) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeEventReferenceDocument))
                }
            }
        }
        input.eventTime?.let { field(EVENTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.eventType?.let { field(EVENTTYPE_DESCRIPTOR, it) }
        input.incidentRecordArn?.let { field(INCIDENTRECORDARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
