// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.paginators

import aws.sdk.kotlin.services.ssmincidents.SsmIncidentsClient
import aws.sdk.kotlin.services.ssmincidents.model.EventSummary
import aws.sdk.kotlin.services.ssmincidents.model.GetResourcePoliciesRequest
import aws.sdk.kotlin.services.ssmincidents.model.GetResourcePoliciesResponse
import aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSummary
import aws.sdk.kotlin.services.ssmincidents.model.ListIncidentRecordsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListIncidentRecordsResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListRelatedItemsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListRelatedItemsResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListReplicationSetsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListReplicationSetsResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListResponsePlansRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListResponsePlansResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsResponse
import aws.sdk.kotlin.services.ssmincidents.model.RelatedItem
import aws.sdk.kotlin.services.ssmincidents.model.ResourcePolicy
import aws.sdk.kotlin.services.ssmincidents.model.ResponsePlanSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetResourcePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetResourcePoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourcePoliciesResponse]
 */
public fun SsmIncidentsClient.getResourcePoliciesPaginated(initialRequest: GetResourcePoliciesRequest): Flow<GetResourcePoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getResourcePoliciesPaginated.getResourcePolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetResourcePoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetResourcePoliciesResponse]
 */
public fun SsmIncidentsClient.getResourcePoliciesPaginated(block: GetResourcePoliciesRequest.Builder.() -> Unit): Flow<GetResourcePoliciesResponse> =
    getResourcePoliciesPaginated(GetResourcePoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getResourcePoliciesPaginated]
 * to access the nested member [ResourcePolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourcePolicy]
 */
@JvmName("getResourcePoliciesResponseResourcePolicy")
public fun Flow<GetResourcePoliciesResponse>.resourcePolicies(): Flow<ResourcePolicy> =
    transform() { response ->
        response.resourcePolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIncidentRecordsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIncidentRecordsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIncidentRecordsResponse]
 */
public fun SsmIncidentsClient.listIncidentRecordsPaginated(initialRequest: ListIncidentRecordsRequest): Flow<ListIncidentRecordsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIncidentRecordsPaginated.listIncidentRecords(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIncidentRecordsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIncidentRecordsResponse]
 */
public fun SsmIncidentsClient.listIncidentRecordsPaginated(block: ListIncidentRecordsRequest.Builder.() -> Unit): Flow<ListIncidentRecordsResponse> =
    listIncidentRecordsPaginated(ListIncidentRecordsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIncidentRecordsPaginated]
 * to access the nested member [IncidentRecordSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IncidentRecordSummary]
 */
@JvmName("listIncidentRecordsResponseIncidentRecordSummary")
public fun Flow<ListIncidentRecordsResponse>.incidentRecordSummaries(): Flow<IncidentRecordSummary> =
    transform() { response ->
        response.incidentRecordSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRelatedItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRelatedItemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRelatedItemsResponse]
 */
public fun SsmIncidentsClient.listRelatedItemsPaginated(initialRequest: ListRelatedItemsRequest): Flow<ListRelatedItemsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRelatedItemsPaginated.listRelatedItems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRelatedItemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRelatedItemsResponse]
 */
public fun SsmIncidentsClient.listRelatedItemsPaginated(block: ListRelatedItemsRequest.Builder.() -> Unit): Flow<ListRelatedItemsResponse> =
    listRelatedItemsPaginated(ListRelatedItemsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRelatedItemsPaginated]
 * to access the nested member [RelatedItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RelatedItem]
 */
@JvmName("listRelatedItemsResponseRelatedItem")
public fun Flow<ListRelatedItemsResponse>.relatedItems(): Flow<RelatedItem> =
    transform() { response ->
        response.relatedItems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReplicationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReplicationSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReplicationSetsResponse]
 */
public fun SsmIncidentsClient.listReplicationSetsPaginated(initialRequest: ListReplicationSetsRequest): Flow<ListReplicationSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReplicationSetsPaginated.listReplicationSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReplicationSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReplicationSetsResponse]
 */
public fun SsmIncidentsClient.listReplicationSetsPaginated(block: ListReplicationSetsRequest.Builder.() -> Unit): Flow<ListReplicationSetsResponse> =
    listReplicationSetsPaginated(ListReplicationSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReplicationSetsPaginated]
 * to access the nested member [Arn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Arn]
 */
@JvmName("listReplicationSetsResponseArn")
public fun Flow<ListReplicationSetsResponse>.replicationSetArns(): Flow<String> =
    transform() { response ->
        response.replicationSetArns?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResponsePlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResponsePlansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResponsePlansResponse]
 */
public fun SsmIncidentsClient.listResponsePlansPaginated(initialRequest: ListResponsePlansRequest): Flow<ListResponsePlansResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResponsePlansPaginated.listResponsePlans(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResponsePlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResponsePlansResponse]
 */
public fun SsmIncidentsClient.listResponsePlansPaginated(block: ListResponsePlansRequest.Builder.() -> Unit): Flow<ListResponsePlansResponse> =
    listResponsePlansPaginated(ListResponsePlansRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResponsePlansPaginated]
 * to access the nested member [ResponsePlanSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResponsePlanSummary]
 */
@JvmName("listResponsePlansResponseResponsePlanSummary")
public fun Flow<ListResponsePlansResponse>.responsePlanSummaries(): Flow<ResponsePlanSummary> =
    transform() { response ->
        response.responsePlanSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTimelineEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTimelineEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTimelineEventsResponse]
 */
public fun SsmIncidentsClient.listTimelineEventsPaginated(initialRequest: ListTimelineEventsRequest): Flow<ListTimelineEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTimelineEventsPaginated.listTimelineEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTimelineEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTimelineEventsResponse]
 */
public fun SsmIncidentsClient.listTimelineEventsPaginated(block: ListTimelineEventsRequest.Builder.() -> Unit): Flow<ListTimelineEventsResponse> =
    listTimelineEventsPaginated(ListTimelineEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTimelineEventsPaginated]
 * to access the nested member [EventSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventSummary]
 */
@JvmName("listTimelineEventsResponseEventSummary")
public fun Flow<ListTimelineEventsResponse>.eventSummaries(): Flow<EventSummary> =
    transform() { response ->
        response.eventSummaries?.forEach {
            emit(it)
        }
    }
