// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model



public class UpdateResponsePlanRequest private constructor(builder: Builder) {
    /**
     * The actions that this response plan takes at the beginning of an incident.
     */
    public val actions: List<Action>? = builder.actions
    /**
     * The Amazon Resource Name (ARN) of the response plan.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Chatbot chat channel used for collaboration during an incident.
     *
     * Use the empty structure to remove the chat channel from the response plan.
     */
    public val chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = builder.chatChannel
    /**
     * A token ensuring that the operation is called only once with the specified details.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The long format name of the response plan. The display name can't contain spaces.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     */
    public val engagements: List<String>? = builder.engagements
    /**
     * The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.
     */
    public val incidentTemplateDedupeString: kotlin.String? = builder.incidentTemplateDedupeString
    /**
     * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
     *
     * **Possible impacts:**
     * + `5` - Severe impact
     * + `4` - High impact
     * + `3` - Medium impact
     * + `2` - Low impact
     * + `1` - No impact
     */
    public val incidentTemplateImpact: kotlin.Int? = builder.incidentTemplateImpact
    /**
     * The Amazon SNS targets that are notified when updates are made to an incident.
     */
    public val incidentTemplateNotificationTargets: List<NotificationTargetItem>? = builder.incidentTemplateNotificationTargets
    /**
     * A brief summary of the incident. This typically contains what has happened, what's currently happening, and next steps.
     */
    public val incidentTemplateSummary: kotlin.String? = builder.incidentTemplateSummary
    /**
     * Tags to assign to the template. When the `StartIncident` API action is called, Incident Manager assigns the tags specified in the template to the incident. To call this action, you must also have permission to call the `TagResource` API action for the incident record resource.
     */
    public val incidentTemplateTags: Map<String, String>? = builder.incidentTemplateTags
    /**
     * The short format name of the incident. The title can't contain spaces.
     */
    public val incidentTemplateTitle: kotlin.String? = builder.incidentTemplateTitle
    /**
     * Information about third-party services integrated into the response plan.
     */
    public val integrations: List<Integration>? = builder.integrations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.UpdateResponsePlanRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateResponsePlanRequest(")
        append("actions=$actions,")
        append("arn=$arn,")
        append("chatChannel=$chatChannel,")
        append("clientToken=$clientToken,")
        append("displayName=$displayName,")
        append("engagements=$engagements,")
        append("incidentTemplateDedupeString=$incidentTemplateDedupeString,")
        append("incidentTemplateImpact=$incidentTemplateImpact,")
        append("incidentTemplateNotificationTargets=$incidentTemplateNotificationTargets,")
        append("incidentTemplateSummary=$incidentTemplateSummary,")
        append("incidentTemplateTags=$incidentTemplateTags,")
        append("incidentTemplateTitle=$incidentTemplateTitle,")
        append("integrations=$integrations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (chatChannel?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (engagements?.hashCode() ?: 0)
        result = 31 * result + (incidentTemplateDedupeString?.hashCode() ?: 0)
        result = 31 * result + (incidentTemplateImpact ?: 0)
        result = 31 * result + (incidentTemplateNotificationTargets?.hashCode() ?: 0)
        result = 31 * result + (incidentTemplateSummary?.hashCode() ?: 0)
        result = 31 * result + (incidentTemplateTags?.hashCode() ?: 0)
        result = 31 * result + (incidentTemplateTitle?.hashCode() ?: 0)
        result = 31 * result + (integrations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateResponsePlanRequest

        if (actions != other.actions) return false
        if (arn != other.arn) return false
        if (chatChannel != other.chatChannel) return false
        if (clientToken != other.clientToken) return false
        if (displayName != other.displayName) return false
        if (engagements != other.engagements) return false
        if (incidentTemplateDedupeString != other.incidentTemplateDedupeString) return false
        if (incidentTemplateImpact != other.incidentTemplateImpact) return false
        if (incidentTemplateNotificationTargets != other.incidentTemplateNotificationTargets) return false
        if (incidentTemplateSummary != other.incidentTemplateSummary) return false
        if (incidentTemplateTags != other.incidentTemplateTags) return false
        if (incidentTemplateTitle != other.incidentTemplateTitle) return false
        if (integrations != other.integrations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.UpdateResponsePlanRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actions that this response plan takes at the beginning of an incident.
         */
        public var actions: List<Action>? = null
        /**
         * The Amazon Resource Name (ARN) of the response plan.
         */
        public var arn: kotlin.String? = null
        /**
         * The Chatbot chat channel used for collaboration during an incident.
         *
         * Use the empty structure to remove the chat channel from the response plan.
         */
        public var chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = null
        /**
         * A token ensuring that the operation is called only once with the specified details.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The long format name of the response plan. The display name can't contain spaces.
         */
        public var displayName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
         */
        public var engagements: List<String>? = null
        /**
         * The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.
         */
        public var incidentTemplateDedupeString: kotlin.String? = null
        /**
         * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
         *
         * **Possible impacts:**
         * + `5` - Severe impact
         * + `4` - High impact
         * + `3` - Medium impact
         * + `2` - Low impact
         * + `1` - No impact
         */
        public var incidentTemplateImpact: kotlin.Int? = null
        /**
         * The Amazon SNS targets that are notified when updates are made to an incident.
         */
        public var incidentTemplateNotificationTargets: List<NotificationTargetItem>? = null
        /**
         * A brief summary of the incident. This typically contains what has happened, what's currently happening, and next steps.
         */
        public var incidentTemplateSummary: kotlin.String? = null
        /**
         * Tags to assign to the template. When the `StartIncident` API action is called, Incident Manager assigns the tags specified in the template to the incident. To call this action, you must also have permission to call the `TagResource` API action for the incident record resource.
         */
        public var incidentTemplateTags: Map<String, String>? = null
        /**
         * The short format name of the incident. The title can't contain spaces.
         */
        public var incidentTemplateTitle: kotlin.String? = null
        /**
         * Information about third-party services integrated into the response plan.
         */
        public var integrations: List<Integration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.UpdateResponsePlanRequest) : this() {
            this.actions = x.actions
            this.arn = x.arn
            this.chatChannel = x.chatChannel
            this.clientToken = x.clientToken
            this.displayName = x.displayName
            this.engagements = x.engagements
            this.incidentTemplateDedupeString = x.incidentTemplateDedupeString
            this.incidentTemplateImpact = x.incidentTemplateImpact
            this.incidentTemplateNotificationTargets = x.incidentTemplateNotificationTargets
            this.incidentTemplateSummary = x.incidentTemplateSummary
            this.incidentTemplateTags = x.incidentTemplateTags
            this.incidentTemplateTitle = x.incidentTemplateTitle
            this.integrations = x.integrations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.UpdateResponsePlanRequest = UpdateResponsePlanRequest(this)
    }
}
