// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model



public class UpdateIncidentRecordRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the incident record you are updating.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Chatbot chat channel where responders can collaborate.
     */
    public val chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = builder.chatChannel
    /**
     * A token that ensures that a client calls the operation only once with the specified details.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Defines the impact of the incident to customers and applications. If you provide an impact for an incident, it overwrites the impact provided by the response plan.
     *
     * **Possible impacts:**
     * + `1` - Critical impact, full application failure that impacts many to all customers.
     * + `2` - High impact, partial application failure with impact to many customers.
     * + `3` - Medium impact, the application is providing reduced service to customers.
     * + `4` - Low impact, customer aren't impacted by the problem yet.
     * + `5` - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
     */
    public val impact: kotlin.Int? = builder.impact
    /**
     * The Amazon SNS targets that Incident Manager notifies when a client updates an incident.
     *
     * Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
     */
    public val notificationTargets: List<NotificationTargetItem>? = builder.notificationTargets
    /**
     * The status of the incident. Possible statuses are `Open` or `Resolved`.
     */
    public val status: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordStatus? = builder.status
    /**
     * A longer description of what occurred during the incident.
     */
    public val summary: kotlin.String? = builder.summary
    /**
     * A brief description of the incident.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.UpdateIncidentRecordRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIncidentRecordRequest(")
        append("arn=$arn,")
        append("chatChannel=$chatChannel,")
        append("clientToken=$clientToken,")
        append("impact=$impact,")
        append("notificationTargets=$notificationTargets,")
        append("status=$status,")
        append("summary=$summary,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (chatChannel?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (impact ?: 0)
        result = 31 * result + (notificationTargets?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIncidentRecordRequest

        if (arn != other.arn) return false
        if (chatChannel != other.chatChannel) return false
        if (clientToken != other.clientToken) return false
        if (impact != other.impact) return false
        if (notificationTargets != other.notificationTargets) return false
        if (status != other.status) return false
        if (summary != other.summary) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.UpdateIncidentRecordRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the incident record you are updating.
         */
        public var arn: kotlin.String? = null
        /**
         * The Chatbot chat channel where responders can collaborate.
         */
        public var chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = null
        /**
         * A token that ensures that a client calls the operation only once with the specified details.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Defines the impact of the incident to customers and applications. If you provide an impact for an incident, it overwrites the impact provided by the response plan.
         *
         * **Possible impacts:**
         * + `1` - Critical impact, full application failure that impacts many to all customers.
         * + `2` - High impact, partial application failure with impact to many customers.
         * + `3` - Medium impact, the application is providing reduced service to customers.
         * + `4` - Low impact, customer aren't impacted by the problem yet.
         * + `5` - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
         */
        public var impact: kotlin.Int? = null
        /**
         * The Amazon SNS targets that Incident Manager notifies when a client updates an incident.
         *
         * Using multiple SNS topics creates redundancy in the event that a Region is down during the incident.
         */
        public var notificationTargets: List<NotificationTargetItem>? = null
        /**
         * The status of the incident. Possible statuses are `Open` or `Resolved`.
         */
        public var status: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordStatus? = null
        /**
         * A longer description of what occurred during the incident.
         */
        public var summary: kotlin.String? = null
        /**
         * A brief description of the incident.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.UpdateIncidentRecordRequest) : this() {
            this.arn = x.arn
            this.chatChannel = x.chatChannel
            this.clientToken = x.clientToken
            this.impact = x.impact
            this.notificationTargets = x.notificationTargets
            this.status = x.status
            this.summary = x.summary
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.UpdateIncidentRecordRequest = UpdateIncidentRecordRequest(this)
    }
}
