// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about what caused the incident to be created in Incident Manager.
 */
public class TriggerDetails private constructor(builder: Builder) {
    /**
     * Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is created.
     */
    public val rawData: kotlin.String? = builder.rawData
    /**
     * Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "`aws.`" Customer-generated events can have any value here, as long as it doesn't begin with "`aws.`" We recommend the use of Java package-name style reverse domain-name strings.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The time that the incident was detected.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp
    /**
     * The Amazon Resource Name (ARN) of the source that detected the incident.
     */
    public val triggerArn: kotlin.String? = builder.triggerArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TriggerDetails(")
        append("rawData=$rawData,")
        append("source=$source,")
        append("timestamp=$timestamp,")
        append("triggerArn=$triggerArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = rawData?.hashCode() ?: 0
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        result = 31 * result + (triggerArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TriggerDetails

        if (rawData != other.rawData) return false
        if (source != other.source) return false
        if (timestamp != other.timestamp) return false
        if (triggerArn != other.triggerArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Raw data passed from either Amazon EventBridge, Amazon CloudWatch, or Incident Manager when an incident is created.
         */
        public var rawData: kotlin.String? = null
        /**
         * Identifies the service that sourced the event. All events sourced from within Amazon Web Services begin with "`aws.`" Customer-generated events can have any value here, as long as it doesn't begin with "`aws.`" We recommend the use of Java package-name style reverse domain-name strings.
         */
        public var source: kotlin.String? = null
        /**
         * The time that the incident was detected.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the source that detected the incident.
         */
        public var triggerArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails) : this() {
            this.rawData = x.rawData
            this.source = x.source
            this.timestamp = x.timestamp
            this.triggerArn = x.triggerArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails = TriggerDetails(this)
    }
}
