// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model



public class StartIncidentRequest private constructor(builder: Builder) {
    /**
     * A token ensuring that the operation is called only once with the specified details.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
     *
     * **Possible impacts:**
     * + `1` - Critical impact, this typically relates to full application failure that impacts many to all customers.
     * + `2` - High impact, partial application failure with impact to many customers.
     * + `3` - Medium impact, the application is providing reduced service to customers.
     * + `4` - Low impact, customer might aren't impacted by the problem yet.
     * + `5` - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
     */
    public val impact: kotlin.Int? = builder.impact
    /**
     * Add related items to the incident for other responders to use. Related items are Amazon Web Services resources, external links, or files uploaded to an Amazon S3 bucket.
     */
    public val relatedItems: List<RelatedItem>? = builder.relatedItems
    /**
     * The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, Amazon SNS topics, runbooks, title, and impact of the incident.
     */
    public val responsePlanArn: kotlin.String? = builder.responsePlanArn
    /**
     * Provide a title for the incident. Providing a title overwrites the title provided by the response plan.
     */
    public val title: kotlin.String? = builder.title
    /**
     * Details of what created the incident record in Incident Manager.
     */
    public val triggerDetails: aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails? = builder.triggerDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.StartIncidentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartIncidentRequest(")
        append("clientToken=$clientToken,")
        append("impact=$impact,")
        append("relatedItems=$relatedItems,")
        append("responsePlanArn=$responsePlanArn,")
        append("title=$title,")
        append("triggerDetails=$triggerDetails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (impact ?: 0)
        result = 31 * result + (relatedItems?.hashCode() ?: 0)
        result = 31 * result + (responsePlanArn?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (triggerDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartIncidentRequest

        if (clientToken != other.clientToken) return false
        if (impact != other.impact) return false
        if (relatedItems != other.relatedItems) return false
        if (responsePlanArn != other.responsePlanArn) return false
        if (title != other.title) return false
        if (triggerDetails != other.triggerDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.StartIncidentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A token ensuring that the operation is called only once with the specified details.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
         *
         * **Possible impacts:**
         * + `1` - Critical impact, this typically relates to full application failure that impacts many to all customers.
         * + `2` - High impact, partial application failure with impact to many customers.
         * + `3` - Medium impact, the application is providing reduced service to customers.
         * + `4` - Low impact, customer might aren't impacted by the problem yet.
         * + `5` - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
         */
        public var impact: kotlin.Int? = null
        /**
         * Add related items to the incident for other responders to use. Related items are Amazon Web Services resources, external links, or files uploaded to an Amazon S3 bucket.
         */
        public var relatedItems: List<RelatedItem>? = null
        /**
         * The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, Amazon SNS topics, runbooks, title, and impact of the incident.
         */
        public var responsePlanArn: kotlin.String? = null
        /**
         * Provide a title for the incident. Providing a title overwrites the title provided by the response plan.
         */
        public var title: kotlin.String? = null
        /**
         * Details of what created the incident record in Incident Manager.
         */
        public var triggerDetails: aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.StartIncidentRequest) : this() {
            this.clientToken = x.clientToken
            this.impact = x.impact
            this.relatedItems = x.relatedItems
            this.responsePlanArn = x.responsePlanArn
            this.title = x.title
            this.triggerDetails = x.triggerDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.StartIncidentRequest = StartIncidentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails] inside the given [block]
         */
        public fun triggerDetails(block: aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails.Builder.() -> kotlin.Unit) {
            this.triggerDetails = aws.sdk.kotlin.services.ssmincidents.model.TriggerDetails.invoke(block)
        }
    }
}
