// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model



/**
 * Details about the Systems Manager automation document that will be used as a runbook during an incident.
 */
public class SsmAutomation private constructor(builder: Builder) {
    /**
     * The automation document's name.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The automation document's version to use when running.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
     */
    public val dynamicParameters: Map<String, DynamicSsmParameterValue>? = builder.dynamicParameters
    /**
     * The key-value pair parameters to use when running the automation document.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The account that the automation document will be run in. This can be in either the management account or an application account.
     */
    public val targetAccount: aws.sdk.kotlin.services.ssmincidents.model.SsmTargetAccount? = builder.targetAccount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.SsmAutomation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SsmAutomation(")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("dynamicParameters=$dynamicParameters,")
        append("parameters=$parameters,")
        append("roleArn=$roleArn,")
        append("targetAccount=$targetAccount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentName?.hashCode() ?: 0
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (dynamicParameters?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (targetAccount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SsmAutomation

        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (dynamicParameters != other.dynamicParameters) return false
        if (parameters != other.parameters) return false
        if (roleArn != other.roleArn) return false
        if (targetAccount != other.targetAccount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.SsmAutomation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The automation document's name.
         */
        public var documentName: kotlin.String? = null
        /**
         * The automation document's version to use when running.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The key-value pair to resolve dynamic parameter values when processing a Systems Manager Automation runbook.
         */
        public var dynamicParameters: Map<String, DynamicSsmParameterValue>? = null
        /**
         * The key-value pair parameters to use when running the automation document.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * The Amazon Resource Name (ARN) of the role that the automation document will assume when running commands.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The account that the automation document will be run in. This can be in either the management account or an application account.
         */
        public var targetAccount: aws.sdk.kotlin.services.ssmincidents.model.SsmTargetAccount? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.SsmAutomation) : this() {
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.dynamicParameters = x.dynamicParameters
            this.parameters = x.parameters
            this.roleArn = x.roleArn
            this.targetAccount = x.targetAccount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.SsmAutomation = SsmAutomation(this)
    }
}
