// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The set of Amazon Web Services Region that your Incident Manager data will be replicated to and the KMS key used to encrypt the data.
 */
public class ReplicationSet private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the replication set.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Details about who created the replication set.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * When the replication set was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * Determines if the replication set deletion protection is enabled or not. If deletion protection is enabled, you can't delete the last Amazon Web Services Region in the replication set.
     */
    public val deletionProtected: kotlin.Boolean? = builder.deletionProtected
    /**
     * Who last modified the replication set.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * When the replication set was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The map between each Amazon Web Services Region in your replication set and the KMS key that's used to encrypt the data in that Region.
     */
    public val regionMap: Map<String, RegionInfo>? = builder.regionMap
    /**
     * The status of the replication set. If the replication set is still pending, you can't use Incident Manager functionality.
     */
    public val status: aws.sdk.kotlin.services.ssmincidents.model.ReplicationSetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.ReplicationSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationSet(")
        append("arn=$arn,")
        append("createdBy=$createdBy,")
        append("createdTime=$createdTime,")
        append("deletionProtected=$deletionProtected,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("regionMap=$regionMap,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (deletionProtected?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (regionMap?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationSet

        if (arn != other.arn) return false
        if (createdBy != other.createdBy) return false
        if (createdTime != other.createdTime) return false
        if (deletionProtected != other.deletionProtected) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (regionMap != other.regionMap) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.ReplicationSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the replication set.
         */
        public var arn: kotlin.String? = null
        /**
         * Details about who created the replication set.
         */
        public var createdBy: kotlin.String? = null
        /**
         * When the replication set was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Determines if the replication set deletion protection is enabled or not. If deletion protection is enabled, you can't delete the last Amazon Web Services Region in the replication set.
         */
        public var deletionProtected: kotlin.Boolean? = null
        /**
         * Who last modified the replication set.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * When the replication set was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The map between each Amazon Web Services Region in your replication set and the KMS key that's used to encrypt the data in that Region.
         */
        public var regionMap: Map<String, RegionInfo>? = null
        /**
         * The status of the replication set. If the replication set is still pending, you can't use Incident Manager functionality.
         */
        public var status: aws.sdk.kotlin.services.ssmincidents.model.ReplicationSetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.ReplicationSet) : this() {
            this.arn = x.arn
            this.createdBy = x.createdBy
            this.createdTime = x.createdTime
            this.deletionProtected = x.deletionProtected
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.regionMap = x.regionMap
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.ReplicationSet = ReplicationSet(this)
    }
}
