// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model



public class ListTimelineEventsRequest private constructor(builder: Builder) {
    /**
     * Filters the timeline events based on the provided conditional values. You can filter timeline events with the following keys:
     * + `eventTime`
     * + `eventType`
     *
     * Note the following when deciding how to use Filters:
     * + If you don't specify a Filter, the response includes all timeline events.
     * + If you specify more than one filter in a single request, the response returns timeline events that match all filters.
     * + If you specify a filter with more than one value, the response returns timeline events that match any of the values provided.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The Amazon Resource Name (ARN) of the incident that includes the timeline event.
     */
    public val incidentRecordArn: kotlin.String? = builder.incidentRecordArn
    /**
     * The maximum number of results per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token to continue to the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Sort timeline events by the specified key value pair.
     */
    public val sortBy: aws.sdk.kotlin.services.ssmincidents.model.TimelineEventSort? = builder.sortBy
    /**
     * Sorts the order of timeline events by the value specified in the `sortBy` field.
     */
    public val sortOrder: aws.sdk.kotlin.services.ssmincidents.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTimelineEventsRequest(")
        append("filters=$filters,")
        append("incidentRecordArn=$incidentRecordArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (incidentRecordArn?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTimelineEventsRequest

        if (filters != other.filters) return false
        if (incidentRecordArn != other.incidentRecordArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters the timeline events based on the provided conditional values. You can filter timeline events with the following keys:
         * + `eventTime`
         * + `eventType`
         *
         * Note the following when deciding how to use Filters:
         * + If you don't specify a Filter, the response includes all timeline events.
         * + If you specify more than one filter in a single request, the response returns timeline events that match all filters.
         * + If you specify a filter with more than one value, the response returns timeline events that match any of the values provided.
         */
        public var filters: List<Filter>? = null
        /**
         * The Amazon Resource Name (ARN) of the incident that includes the timeline event.
         */
        public var incidentRecordArn: kotlin.String? = null
        /**
         * The maximum number of results per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token to continue to the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Sort timeline events by the specified key value pair.
         */
        public var sortBy: aws.sdk.kotlin.services.ssmincidents.model.TimelineEventSort? = null
        /**
         * Sorts the order of timeline events by the value specified in the `sortBy` field.
         */
        public var sortOrder: aws.sdk.kotlin.services.ssmincidents.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsRequest) : this() {
            this.filters = x.filters
            this.incidentRecordArn = x.incidentRecordArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsRequest = ListTimelineEventsRequest(this)
    }
}
