// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model



/**
 * Basic details used in creating a response plan. The response plan is then used to create an incident record.
 */
public class IncidentTemplate private constructor(builder: Builder) {
    /**
     * Used to stop Incident Manager from creating multiple incident records for the same incident.
     */
    public val dedupeString: kotlin.String? = builder.dedupeString
    /**
     * The impact of the incident on your customers and applications.
     */
    public val impact: kotlin.Int? = builder.impact
    /**
     * Tags to assign to the template. When the `StartIncident` API action is called, Incident Manager assigns the tags specified in the template to the incident.
     */
    public val incidentTags: Map<String, String>? = builder.incidentTags
    /**
     * The Amazon SNS targets that are notified when updates are made to an incident.
     */
    public val notificationTargets: List<NotificationTargetItem>? = builder.notificationTargets
    /**
     * The summary of the incident. The summary is a brief synopsis of what occurred, what's currently happening, and context.
     */
    public val summary: kotlin.String? = builder.summary
    /**
     * The title of the incident.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IncidentTemplate(")
        append("dedupeString=$dedupeString,")
        append("impact=$impact,")
        append("incidentTags=$incidentTags,")
        append("notificationTargets=$notificationTargets,")
        append("summary=$summary,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dedupeString?.hashCode() ?: 0
        result = 31 * result + (impact ?: 0)
        result = 31 * result + (incidentTags?.hashCode() ?: 0)
        result = 31 * result + (notificationTargets?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IncidentTemplate

        if (dedupeString != other.dedupeString) return false
        if (impact != other.impact) return false
        if (incidentTags != other.incidentTags) return false
        if (notificationTargets != other.notificationTargets) return false
        if (summary != other.summary) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Used to stop Incident Manager from creating multiple incident records for the same incident.
         */
        public var dedupeString: kotlin.String? = null
        /**
         * The impact of the incident on your customers and applications.
         */
        public var impact: kotlin.Int? = null
        /**
         * Tags to assign to the template. When the `StartIncident` API action is called, Incident Manager assigns the tags specified in the template to the incident.
         */
        public var incidentTags: Map<String, String>? = null
        /**
         * The Amazon SNS targets that are notified when updates are made to an incident.
         */
        public var notificationTargets: List<NotificationTargetItem>? = null
        /**
         * The summary of the incident. The summary is a brief synopsis of what occurred, what's currently happening, and context.
         */
        public var summary: kotlin.String? = null
        /**
         * The title of the incident.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate) : this() {
            this.dedupeString = x.dedupeString
            this.impact = x.impact
            this.incidentTags = x.incidentTags
            this.notificationTargets = x.notificationTargets
            this.summary = x.summary
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate = IncidentTemplate(this)
    }
}
