// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details describing an incident record.
 */
public class IncidentRecordSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the incident.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time the incident was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Defines the impact to customers and applications.
     */
    public val impact: kotlin.Int? = builder.impact
    /**
     * What caused Incident Manager to create the incident.
     */
    public val incidentRecordSource: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource? = builder.incidentRecordSource
    /**
     * The time the incident was resolved.
     */
    public val resolvedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.resolvedTime
    /**
     * The current status of the incident.
     */
    public val status: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordStatus? = builder.status
    /**
     * The title of the incident. This value is either provided by the response plan or overwritten on creation.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IncidentRecordSummary(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("impact=$impact,")
        append("incidentRecordSource=$incidentRecordSource,")
        append("resolvedTime=$resolvedTime,")
        append("status=$status,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (impact ?: 0)
        result = 31 * result + (incidentRecordSource?.hashCode() ?: 0)
        result = 31 * result + (resolvedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IncidentRecordSummary

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (impact != other.impact) return false
        if (incidentRecordSource != other.incidentRecordSource) return false
        if (resolvedTime != other.resolvedTime) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the incident.
         */
        public var arn: kotlin.String? = null
        /**
         * The time the incident was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Defines the impact to customers and applications.
         */
        public var impact: kotlin.Int? = null
        /**
         * What caused Incident Manager to create the incident.
         */
        public var incidentRecordSource: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource? = null
        /**
         * The time the incident was resolved.
         */
        public var resolvedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the incident.
         */
        public var status: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordStatus? = null
        /**
         * The title of the incident. This value is either provided by the response plan or overwritten on creation.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSummary) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.impact = x.impact
            this.incidentRecordSource = x.incidentRecordSource
            this.resolvedTime = x.resolvedTime
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSummary = IncidentRecordSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource] inside the given [block]
         */
        public fun incidentRecordSource(block: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource.Builder.() -> kotlin.Unit) {
            this.incidentRecordSource = aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource.invoke(block)
        }
    }
}
