// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The record of the incident that's created when an incident occurs.
 */
public class IncidentRecord private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the incident record.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The runbook, or automation document, that's run at the beginning of the incident.
     */
    public val automationExecutions: List<AutomationExecution>? = builder.automationExecutions
    /**
     * The chat channel used for collaboration during an incident.
     */
    public val chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = builder.chatChannel
    /**
     * The time that Incident Manager created the incident record.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.
     */
    public val dedupeString: kotlin.String? = builder.dedupeString
    /**
     * The impact of the incident on customers and applications.
     */
    public val impact: kotlin.Int? = builder.impact
    /**
     * Details about the action that started the incident.
     */
    public val incidentRecordSource: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource? = builder.incidentRecordSource
    /**
     * Who modified the incident most recently.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The time at which the incident was most recently modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon SNS targets that are notified when updates are made to an incident.
     */
    public val notificationTargets: List<NotificationTargetItem>? = builder.notificationTargets
    /**
     * The time at which the incident was resolved. This appears as a timeline event.
     */
    public val resolvedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.resolvedTime
    /**
     * The current status of the incident.
     */
    public val status: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordStatus? = builder.status
    /**
     * The summary of the incident. The summary is a brief synopsis of what occurred, what's currently happening, and context of the incident.
     */
    public val summary: kotlin.String? = builder.summary
    /**
     * The title of the incident.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.IncidentRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IncidentRecord(")
        append("arn=$arn,")
        append("automationExecutions=$automationExecutions,")
        append("chatChannel=$chatChannel,")
        append("creationTime=$creationTime,")
        append("dedupeString=$dedupeString,")
        append("impact=$impact,")
        append("incidentRecordSource=$incidentRecordSource,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("notificationTargets=$notificationTargets,")
        append("resolvedTime=$resolvedTime,")
        append("status=$status,")
        append("summary=$summary,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (automationExecutions?.hashCode() ?: 0)
        result = 31 * result + (chatChannel?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (dedupeString?.hashCode() ?: 0)
        result = 31 * result + (impact ?: 0)
        result = 31 * result + (incidentRecordSource?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (notificationTargets?.hashCode() ?: 0)
        result = 31 * result + (resolvedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IncidentRecord

        if (arn != other.arn) return false
        if (automationExecutions != other.automationExecutions) return false
        if (chatChannel != other.chatChannel) return false
        if (creationTime != other.creationTime) return false
        if (dedupeString != other.dedupeString) return false
        if (impact != other.impact) return false
        if (incidentRecordSource != other.incidentRecordSource) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (notificationTargets != other.notificationTargets) return false
        if (resolvedTime != other.resolvedTime) return false
        if (status != other.status) return false
        if (summary != other.summary) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.IncidentRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the incident record.
         */
        public var arn: kotlin.String? = null
        /**
         * The runbook, or automation document, that's run at the beginning of the incident.
         */
        public var automationExecutions: List<AutomationExecution>? = null
        /**
         * The chat channel used for collaboration during an incident.
         */
        public var chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = null
        /**
         * The time that Incident Manager created the incident record.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The string Incident Manager uses to prevent duplicate incidents from being created by the same incident in the same account.
         */
        public var dedupeString: kotlin.String? = null
        /**
         * The impact of the incident on customers and applications.
         */
        public var impact: kotlin.Int? = null
        /**
         * Details about the action that started the incident.
         */
        public var incidentRecordSource: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource? = null
        /**
         * Who modified the incident most recently.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The time at which the incident was most recently modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon SNS targets that are notified when updates are made to an incident.
         */
        public var notificationTargets: List<NotificationTargetItem>? = null
        /**
         * The time at which the incident was resolved. This appears as a timeline event.
         */
        public var resolvedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the incident.
         */
        public var status: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordStatus? = null
        /**
         * The summary of the incident. The summary is a brief synopsis of what occurred, what's currently happening, and context of the incident.
         */
        public var summary: kotlin.String? = null
        /**
         * The title of the incident.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecord) : this() {
            this.arn = x.arn
            this.automationExecutions = x.automationExecutions
            this.chatChannel = x.chatChannel
            this.creationTime = x.creationTime
            this.dedupeString = x.dedupeString
            this.impact = x.impact
            this.incidentRecordSource = x.incidentRecordSource
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.notificationTargets = x.notificationTargets
            this.resolvedTime = x.resolvedTime
            this.status = x.status
            this.summary = x.summary
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.IncidentRecord = IncidentRecord(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource] inside the given [block]
         */
        public fun incidentRecordSource(block: aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource.Builder.() -> kotlin.Unit) {
            this.incidentRecordSource = aws.sdk.kotlin.services.ssmincidents.model.IncidentRecordSource.invoke(block)
        }
    }
}
