// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a timeline event during an incident.
 */
public class EventSummary private constructor(builder: Builder) {
    /**
     * The timeline event ID.
     */
    public val eventId: kotlin.String? = builder.eventId
    /**
     * A list of references in a `TimelineEvent`.
     */
    public val eventReferences: List<EventReference>? = builder.eventReferences
    /**
     * The time that the event occurred.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * The type of event. The timeline event must be `Custom Event`.
     */
    public val eventType: kotlin.String? = builder.eventType
    /**
     * The time that the timeline event was last updated.
     */
    public val eventUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventUpdatedTime
    /**
     * The Amazon Resource Name (ARN) of the incident that the event happened during.
     */
    public val incidentRecordArn: kotlin.String? = builder.incidentRecordArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.EventSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventSummary(")
        append("eventId=$eventId,")
        append("eventReferences=$eventReferences,")
        append("eventTime=$eventTime,")
        append("eventType=$eventType,")
        append("eventUpdatedTime=$eventUpdatedTime,")
        append("incidentRecordArn=$incidentRecordArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventId?.hashCode() ?: 0
        result = 31 * result + (eventReferences?.hashCode() ?: 0)
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (eventUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (incidentRecordArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventSummary

        if (eventId != other.eventId) return false
        if (eventReferences != other.eventReferences) return false
        if (eventTime != other.eventTime) return false
        if (eventType != other.eventType) return false
        if (eventUpdatedTime != other.eventUpdatedTime) return false
        if (incidentRecordArn != other.incidentRecordArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.EventSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timeline event ID.
         */
        public var eventId: kotlin.String? = null
        /**
         * A list of references in a `TimelineEvent`.
         */
        public var eventReferences: List<EventReference>? = null
        /**
         * The time that the event occurred.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of event. The timeline event must be `Custom Event`.
         */
        public var eventType: kotlin.String? = null
        /**
         * The time that the timeline event was last updated.
         */
        public var eventUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the incident that the event happened during.
         */
        public var incidentRecordArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.EventSummary) : this() {
            this.eventId = x.eventId
            this.eventReferences = x.eventReferences
            this.eventTime = x.eventTime
            this.eventType = x.eventType
            this.eventUpdatedTime = x.eventUpdatedTime
            this.incidentRecordArn = x.incidentRecordArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.EventSummary = EventSummary(this)
    }
}
