// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents.model



public class CreateResponsePlanRequest private constructor(builder: Builder) {
    /**
     * The actions that the response plan starts at the beginning of an incident.
     */
    public val actions: List<Action>? = builder.actions
    /**
     * The Chatbot chat channel used for collaboration during an incident.
     */
    public val chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = builder.chatChannel
    /**
     * A token ensuring that the operation is called only once with the specified details.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The long format of the response plan name. This field can contain spaces.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     */
    public val engagements: List<String>? = builder.engagements
    /**
     * Details used to create an incident when using this response plan.
     */
    public val incidentTemplate: aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate? = builder.incidentTemplate
    /**
     * Information about third-party services integrated into the response plan.
     */
    public val integrations: List<Integration>? = builder.integrations
    /**
     * The short format name of the response plan. Can't include spaces.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of tags that you are adding to the response plan.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmincidents.model.CreateResponsePlanRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResponsePlanRequest(")
        append("actions=$actions,")
        append("chatChannel=$chatChannel,")
        append("clientToken=$clientToken,")
        append("displayName=$displayName,")
        append("engagements=$engagements,")
        append("incidentTemplate=$incidentTemplate,")
        append("integrations=$integrations,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (chatChannel?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (engagements?.hashCode() ?: 0)
        result = 31 * result + (incidentTemplate?.hashCode() ?: 0)
        result = 31 * result + (integrations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateResponsePlanRequest

        if (actions != other.actions) return false
        if (chatChannel != other.chatChannel) return false
        if (clientToken != other.clientToken) return false
        if (displayName != other.displayName) return false
        if (engagements != other.engagements) return false
        if (incidentTemplate != other.incidentTemplate) return false
        if (integrations != other.integrations) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmincidents.model.CreateResponsePlanRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actions that the response plan starts at the beginning of an incident.
         */
        public var actions: List<Action>? = null
        /**
         * The Chatbot chat channel used for collaboration during an incident.
         */
        public var chatChannel: aws.sdk.kotlin.services.ssmincidents.model.ChatChannel? = null
        /**
         * A token ensuring that the operation is called only once with the specified details.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The long format of the response plan name. This field can contain spaces.
         */
        public var displayName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
         */
        public var engagements: List<String>? = null
        /**
         * Details used to create an incident when using this response plan.
         */
        public var incidentTemplate: aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate? = null
        /**
         * Information about third-party services integrated into the response plan.
         */
        public var integrations: List<Integration>? = null
        /**
         * The short format name of the response plan. Can't include spaces.
         */
        public var name: kotlin.String? = null
        /**
         * A list of tags that you are adding to the response plan.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmincidents.model.CreateResponsePlanRequest) : this() {
            this.actions = x.actions
            this.chatChannel = x.chatChannel
            this.clientToken = x.clientToken
            this.displayName = x.displayName
            this.engagements = x.engagements
            this.incidentTemplate = x.incidentTemplate
            this.integrations = x.integrations
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmincidents.model.CreateResponsePlanRequest = CreateResponsePlanRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate] inside the given [block]
         */
        public fun incidentTemplate(block: aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate.Builder.() -> kotlin.Unit) {
            this.incidentTemplate = aws.sdk.kotlin.services.ssmincidents.model.IncidentTemplate.invoke(block)
        }
    }
}
