// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmincidents

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.ssmincidents.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.ssmincidents.endpoints.EndpointParameters
import aws.sdk.kotlin.services.ssmincidents.endpoints.EndpointProvider
import aws.sdk.kotlin.services.ssmincidents.model.CreateReplicationSetRequest
import aws.sdk.kotlin.services.ssmincidents.model.CreateReplicationSetResponse
import aws.sdk.kotlin.services.ssmincidents.model.CreateResponsePlanRequest
import aws.sdk.kotlin.services.ssmincidents.model.CreateResponsePlanResponse
import aws.sdk.kotlin.services.ssmincidents.model.CreateTimelineEventRequest
import aws.sdk.kotlin.services.ssmincidents.model.CreateTimelineEventResponse
import aws.sdk.kotlin.services.ssmincidents.model.DeleteIncidentRecordRequest
import aws.sdk.kotlin.services.ssmincidents.model.DeleteIncidentRecordResponse
import aws.sdk.kotlin.services.ssmincidents.model.DeleteReplicationSetRequest
import aws.sdk.kotlin.services.ssmincidents.model.DeleteReplicationSetResponse
import aws.sdk.kotlin.services.ssmincidents.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.ssmincidents.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.ssmincidents.model.DeleteResponsePlanRequest
import aws.sdk.kotlin.services.ssmincidents.model.DeleteResponsePlanResponse
import aws.sdk.kotlin.services.ssmincidents.model.DeleteTimelineEventRequest
import aws.sdk.kotlin.services.ssmincidents.model.DeleteTimelineEventResponse
import aws.sdk.kotlin.services.ssmincidents.model.GetIncidentRecordRequest
import aws.sdk.kotlin.services.ssmincidents.model.GetIncidentRecordResponse
import aws.sdk.kotlin.services.ssmincidents.model.GetReplicationSetRequest
import aws.sdk.kotlin.services.ssmincidents.model.GetReplicationSetResponse
import aws.sdk.kotlin.services.ssmincidents.model.GetResourcePoliciesRequest
import aws.sdk.kotlin.services.ssmincidents.model.GetResourcePoliciesResponse
import aws.sdk.kotlin.services.ssmincidents.model.GetResponsePlanRequest
import aws.sdk.kotlin.services.ssmincidents.model.GetResponsePlanResponse
import aws.sdk.kotlin.services.ssmincidents.model.GetTimelineEventRequest
import aws.sdk.kotlin.services.ssmincidents.model.GetTimelineEventResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListIncidentRecordsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListIncidentRecordsResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListRelatedItemsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListRelatedItemsResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListReplicationSetsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListReplicationSetsResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListResponsePlansRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListResponsePlansResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsRequest
import aws.sdk.kotlin.services.ssmincidents.model.ListTimelineEventsResponse
import aws.sdk.kotlin.services.ssmincidents.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.ssmincidents.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.ssmincidents.model.StartIncidentRequest
import aws.sdk.kotlin.services.ssmincidents.model.StartIncidentResponse
import aws.sdk.kotlin.services.ssmincidents.model.TagResourceRequest
import aws.sdk.kotlin.services.ssmincidents.model.TagResourceResponse
import aws.sdk.kotlin.services.ssmincidents.model.UntagResourceRequest
import aws.sdk.kotlin.services.ssmincidents.model.UntagResourceResponse
import aws.sdk.kotlin.services.ssmincidents.model.UpdateDeletionProtectionRequest
import aws.sdk.kotlin.services.ssmincidents.model.UpdateDeletionProtectionResponse
import aws.sdk.kotlin.services.ssmincidents.model.UpdateIncidentRecordRequest
import aws.sdk.kotlin.services.ssmincidents.model.UpdateIncidentRecordResponse
import aws.sdk.kotlin.services.ssmincidents.model.UpdateRelatedItemsRequest
import aws.sdk.kotlin.services.ssmincidents.model.UpdateRelatedItemsResponse
import aws.sdk.kotlin.services.ssmincidents.model.UpdateReplicationSetRequest
import aws.sdk.kotlin.services.ssmincidents.model.UpdateReplicationSetResponse
import aws.sdk.kotlin.services.ssmincidents.model.UpdateResponsePlanRequest
import aws.sdk.kotlin.services.ssmincidents.model.UpdateResponsePlanResponse
import aws.sdk.kotlin.services.ssmincidents.model.UpdateTimelineEventRequest
import aws.sdk.kotlin.services.ssmincidents.model.UpdateTimelineEventResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * Systems Manager Incident Manager is an incident management console designed to help users mitigate and recover from incidents affecting their Amazon Web Services-hosted applications. An incident is any unplanned interruption or reduction in quality of services.
 *
 * Incident Manager increases incident resolution by notifying responders of impact, highlighting relevant troubleshooting data, and providing collaboration tools to get services back up and running. To achieve the primary goal of reducing the time-to-resolution of critical incidents, Incident Manager automates response plans and enables responder team escalation.
 */
public interface SsmIncidentsClient : SdkClient {
    /**
     * SsmIncidentsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SsmIncidentsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SsmIncidentsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SsmIncidentsClient = DefaultSsmIncidentsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SSM Incidents"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * A replication set replicates and encrypts your data to the provided Regions with the provided KMS key.
     */
    public suspend fun createReplicationSet(input: CreateReplicationSetRequest): CreateReplicationSetResponse

    /**
     * Creates a response plan that automates the initial response to incidents. A response plan engages contacts, starts chat channel collaboration, and initiates runbooks at the beginning of an incident.
     */
    public suspend fun createResponsePlan(input: CreateResponsePlanRequest): CreateResponsePlanResponse

    /**
     * Creates a custom timeline event on the incident details page of an incident record. Incident Manager automatically creates timeline events that mark key moments during an incident. You can create custom timeline events to mark important events that Incident Manager can detect automatically.
     */
    public suspend fun createTimelineEvent(input: CreateTimelineEventRequest): CreateTimelineEventResponse

    /**
     * Delete an incident record from Incident Manager.
     */
    public suspend fun deleteIncidentRecord(input: DeleteIncidentRecordRequest): DeleteIncidentRecordResponse

    /**
     * Deletes all Regions in your replication set. Deleting the replication set deletes all Incident Manager data.
     */
    public suspend fun deleteReplicationSet(input: DeleteReplicationSetRequest): DeleteReplicationSetResponse

    /**
     * Deletes the resource policy that Resource Access Manager uses to share your Incident Manager resource.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge events from creating an incident with this response plan.
     */
    public suspend fun deleteResponsePlan(input: DeleteResponsePlanRequest): DeleteResponsePlanResponse

    /**
     * Deletes a timeline event from an incident.
     */
    public suspend fun deleteTimelineEvent(input: DeleteTimelineEventRequest): DeleteTimelineEventResponse

    /**
     * Returns the details for the specified incident record.
     */
    public suspend fun getIncidentRecord(input: GetIncidentRecordRequest): GetIncidentRecordResponse

    /**
     * Retrieve your Incident Manager replication set.
     */
    public suspend fun getReplicationSet(input: GetReplicationSetRequest): GetReplicationSetResponse

    /**
     * Retrieves the resource policies attached to the specified response plan.
     */
    public suspend fun getResourcePolicies(input: GetResourcePoliciesRequest): GetResourcePoliciesResponse

    /**
     * Retrieves the details of the specified response plan.
     */
    public suspend fun getResponsePlan(input: GetResponsePlanRequest): GetResponsePlanResponse

    /**
     * Retrieves a timeline event based on its ID and incident record.
     */
    public suspend fun getTimelineEvent(input: GetTimelineEventRequest): GetTimelineEventResponse

    /**
     * Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the incident record you want to update.
     */
    public suspend fun listIncidentRecords(input: ListIncidentRecordsRequest = ListIncidentRecordsRequest {}): ListIncidentRecordsResponse

    /**
     * List all related items for an incident record.
     */
    public suspend fun listRelatedItems(input: ListRelatedItemsRequest): ListRelatedItemsResponse

    /**
     * Lists details about the replication set configured in your account.
     */
    public suspend fun listReplicationSets(input: ListReplicationSetsRequest = ListReplicationSetsRequest {}): ListReplicationSetsResponse

    /**
     * Lists all response plans in your account.
     */
    public suspend fun listResponsePlans(input: ListResponsePlansRequest = ListResponsePlansRequest {}): ListResponsePlansResponse

    /**
     * Lists the tags that are attached to the specified response plan.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists timeline events for the specified incident record.
     */
    public suspend fun listTimelineEvents(input: ListTimelineEventsRequest): ListTimelineEventsResponse

    /**
     * Adds a resource policy to the specified response plan. The resource policy is used to share the response plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Cross-Region and cross-account incident management](https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-manager-cross-account-cross-region.html).
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Used to start an incident from CloudWatch alarms, EventBridge events, or manually.
     */
    public suspend fun startIncident(input: StartIncidentRequest): StartIncidentResponse

    /**
     * Adds a tag to a response plan.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update deletion protection to either allow or deny deletion of the final Region in a replication set.
     */
    public suspend fun updateDeletionProtection(input: UpdateDeletionProtectionRequest): UpdateDeletionProtectionResponse

    /**
     * Update the details of an incident record. You can use this operation to update an incident record from the defined chat channel. For more information about using actions in chat channels, see [Interacting through chat](https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact).
     */
    public suspend fun updateIncidentRecord(input: UpdateIncidentRecordRequest): UpdateIncidentRecordResponse

    /**
     * Add or remove related items from the related items tab of an incident record.
     */
    public suspend fun updateRelatedItems(input: UpdateRelatedItemsRequest): UpdateRelatedItemsResponse

    /**
     * Add or delete Regions from your replication set.
     */
    public suspend fun updateReplicationSet(input: UpdateReplicationSetRequest): UpdateReplicationSetResponse

    /**
     * Updates the specified response plan.
     */
    public suspend fun updateResponsePlan(input: UpdateResponsePlanRequest): UpdateResponsePlanResponse

    /**
     * Updates a timeline event. You can update events of type `Custom Event`.
     */
    public suspend fun updateTimelineEvent(input: UpdateTimelineEventRequest): UpdateTimelineEventResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SsmIncidentsClient.withConfig(block: SsmIncidentsClient.Config.Builder.() -> Unit): SsmIncidentsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSsmIncidentsClient(newConfig)
}

/**
 * A replication set replicates and encrypts your data to the provided Regions with the provided KMS key.
 */
public suspend inline fun SsmIncidentsClient.createReplicationSet(crossinline block: CreateReplicationSetRequest.Builder.() -> Unit): CreateReplicationSetResponse = createReplicationSet(CreateReplicationSetRequest.Builder().apply(block).build())

/**
 * Creates a response plan that automates the initial response to incidents. A response plan engages contacts, starts chat channel collaboration, and initiates runbooks at the beginning of an incident.
 */
public suspend inline fun SsmIncidentsClient.createResponsePlan(crossinline block: CreateResponsePlanRequest.Builder.() -> Unit): CreateResponsePlanResponse = createResponsePlan(CreateResponsePlanRequest.Builder().apply(block).build())

/**
 * Creates a custom timeline event on the incident details page of an incident record. Incident Manager automatically creates timeline events that mark key moments during an incident. You can create custom timeline events to mark important events that Incident Manager can detect automatically.
 */
public suspend inline fun SsmIncidentsClient.createTimelineEvent(crossinline block: CreateTimelineEventRequest.Builder.() -> Unit): CreateTimelineEventResponse = createTimelineEvent(CreateTimelineEventRequest.Builder().apply(block).build())

/**
 * Delete an incident record from Incident Manager.
 */
public suspend inline fun SsmIncidentsClient.deleteIncidentRecord(crossinline block: DeleteIncidentRecordRequest.Builder.() -> Unit): DeleteIncidentRecordResponse = deleteIncidentRecord(DeleteIncidentRecordRequest.Builder().apply(block).build())

/**
 * Deletes all Regions in your replication set. Deleting the replication set deletes all Incident Manager data.
 */
public suspend inline fun SsmIncidentsClient.deleteReplicationSet(crossinline block: DeleteReplicationSetRequest.Builder.() -> Unit): DeleteReplicationSetResponse = deleteReplicationSet(DeleteReplicationSetRequest.Builder().apply(block).build())

/**
 * Deletes the resource policy that Resource Access Manager uses to share your Incident Manager resource.
 */
public suspend inline fun SsmIncidentsClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge events from creating an incident with this response plan.
 */
public suspend inline fun SsmIncidentsClient.deleteResponsePlan(crossinline block: DeleteResponsePlanRequest.Builder.() -> Unit): DeleteResponsePlanResponse = deleteResponsePlan(DeleteResponsePlanRequest.Builder().apply(block).build())

/**
 * Deletes a timeline event from an incident.
 */
public suspend inline fun SsmIncidentsClient.deleteTimelineEvent(crossinline block: DeleteTimelineEventRequest.Builder.() -> Unit): DeleteTimelineEventResponse = deleteTimelineEvent(DeleteTimelineEventRequest.Builder().apply(block).build())

/**
 * Returns the details for the specified incident record.
 */
public suspend inline fun SsmIncidentsClient.getIncidentRecord(crossinline block: GetIncidentRecordRequest.Builder.() -> Unit): GetIncidentRecordResponse = getIncidentRecord(GetIncidentRecordRequest.Builder().apply(block).build())

/**
 * Retrieve your Incident Manager replication set.
 */
public suspend inline fun SsmIncidentsClient.getReplicationSet(crossinline block: GetReplicationSetRequest.Builder.() -> Unit): GetReplicationSetResponse = getReplicationSet(GetReplicationSetRequest.Builder().apply(block).build())

/**
 * Retrieves the resource policies attached to the specified response plan.
 */
public suspend inline fun SsmIncidentsClient.getResourcePolicies(crossinline block: GetResourcePoliciesRequest.Builder.() -> Unit): GetResourcePoliciesResponse = getResourcePolicies(GetResourcePoliciesRequest.Builder().apply(block).build())

/**
 * Retrieves the details of the specified response plan.
 */
public suspend inline fun SsmIncidentsClient.getResponsePlan(crossinline block: GetResponsePlanRequest.Builder.() -> Unit): GetResponsePlanResponse = getResponsePlan(GetResponsePlanRequest.Builder().apply(block).build())

/**
 * Retrieves a timeline event based on its ID and incident record.
 */
public suspend inline fun SsmIncidentsClient.getTimelineEvent(crossinline block: GetTimelineEventRequest.Builder.() -> Unit): GetTimelineEventResponse = getTimelineEvent(GetTimelineEventRequest.Builder().apply(block).build())

/**
 * Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the incident record you want to update.
 */
public suspend inline fun SsmIncidentsClient.listIncidentRecords(crossinline block: ListIncidentRecordsRequest.Builder.() -> Unit): ListIncidentRecordsResponse = listIncidentRecords(ListIncidentRecordsRequest.Builder().apply(block).build())

/**
 * List all related items for an incident record.
 */
public suspend inline fun SsmIncidentsClient.listRelatedItems(crossinline block: ListRelatedItemsRequest.Builder.() -> Unit): ListRelatedItemsResponse = listRelatedItems(ListRelatedItemsRequest.Builder().apply(block).build())

/**
 * Lists details about the replication set configured in your account.
 */
public suspend inline fun SsmIncidentsClient.listReplicationSets(crossinline block: ListReplicationSetsRequest.Builder.() -> Unit): ListReplicationSetsResponse = listReplicationSets(ListReplicationSetsRequest.Builder().apply(block).build())

/**
 * Lists all response plans in your account.
 */
public suspend inline fun SsmIncidentsClient.listResponsePlans(crossinline block: ListResponsePlansRequest.Builder.() -> Unit): ListResponsePlansResponse = listResponsePlans(ListResponsePlansRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to the specified response plan.
 */
public suspend inline fun SsmIncidentsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists timeline events for the specified incident record.
 */
public suspend inline fun SsmIncidentsClient.listTimelineEvents(crossinline block: ListTimelineEventsRequest.Builder.() -> Unit): ListTimelineEventsResponse = listTimelineEvents(ListTimelineEventsRequest.Builder().apply(block).build())

/**
 * Adds a resource policy to the specified response plan. The resource policy is used to share the response plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Cross-Region and cross-account incident management](https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-manager-cross-account-cross-region.html).
 */
public suspend inline fun SsmIncidentsClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Used to start an incident from CloudWatch alarms, EventBridge events, or manually.
 */
public suspend inline fun SsmIncidentsClient.startIncident(crossinline block: StartIncidentRequest.Builder.() -> Unit): StartIncidentResponse = startIncident(StartIncidentRequest.Builder().apply(block).build())

/**
 * Adds a tag to a response plan.
 */
public suspend inline fun SsmIncidentsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun SsmIncidentsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update deletion protection to either allow or deny deletion of the final Region in a replication set.
 */
public suspend inline fun SsmIncidentsClient.updateDeletionProtection(crossinline block: UpdateDeletionProtectionRequest.Builder.() -> Unit): UpdateDeletionProtectionResponse = updateDeletionProtection(UpdateDeletionProtectionRequest.Builder().apply(block).build())

/**
 * Update the details of an incident record. You can use this operation to update an incident record from the defined chat channel. For more information about using actions in chat channels, see [Interacting through chat](https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact).
 */
public suspend inline fun SsmIncidentsClient.updateIncidentRecord(crossinline block: UpdateIncidentRecordRequest.Builder.() -> Unit): UpdateIncidentRecordResponse = updateIncidentRecord(UpdateIncidentRecordRequest.Builder().apply(block).build())

/**
 * Add or remove related items from the related items tab of an incident record.
 */
public suspend inline fun SsmIncidentsClient.updateRelatedItems(crossinline block: UpdateRelatedItemsRequest.Builder.() -> Unit): UpdateRelatedItemsResponse = updateRelatedItems(UpdateRelatedItemsRequest.Builder().apply(block).build())

/**
 * Add or delete Regions from your replication set.
 */
public suspend inline fun SsmIncidentsClient.updateReplicationSet(crossinline block: UpdateReplicationSetRequest.Builder.() -> Unit): UpdateReplicationSetResponse = updateReplicationSet(UpdateReplicationSetRequest.Builder().apply(block).build())

/**
 * Updates the specified response plan.
 */
public suspend inline fun SsmIncidentsClient.updateResponsePlan(crossinline block: UpdateResponsePlanRequest.Builder.() -> Unit): UpdateResponsePlanResponse = updateResponsePlan(UpdateResponsePlanRequest.Builder().apply(block).build())

/**
 * Updates a timeline event. You can update events of type `Custom Event`.
 */
public suspend inline fun SsmIncidentsClient.updateTimelineEvent(crossinline block: UpdateTimelineEventRequest.Builder.() -> Unit): UpdateTimelineEventResponse = updateTimelineEvent(UpdateTimelineEventRequest.Builder().apply(block).build())
