// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model



class AcceptPageRequest private constructor(builder: Builder) {
    /**
     * The accept code is a 6-digit code used to acknowledge the page.
     */
    val acceptCode: kotlin.String? = builder.acceptCode
    /**
     * An optional field that Incident Manager uses to ENFORCE
     * AcceptCode validation when acknowledging an page. Acknowledgement can occur by
     * replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode
     * validation causes Incident Manager to verify that the code entered by the user matches the
     * code sent by Incident Manager with the page.
     * Incident Manager can also IGNORE
     * AcceptCode validation. Ignoring AcceptCode validation causes
     * Incident Manager to accept any value entered for the AcceptCode.
     */
    val acceptCodeValidation: aws.sdk.kotlin.services.ssmcontacts.model.AcceptCodeValidation? = builder.acceptCodeValidation
    /**
     * The type indicates if the page was DELIVERED or READ.
     */
    val acceptType: aws.sdk.kotlin.services.ssmcontacts.model.AcceptType? = builder.acceptType
    /**
     * The ARN of the contact channel.
     */
    val contactChannelId: kotlin.String? = builder.contactChannelId
    /**
     * Information provided by the user when the user acknowledges the page.
     */
    val note: kotlin.String? = builder.note
    /**
     * The Amazon Resource Name (ARN) of the engagement to a contact channel.
     */
    val pageId: kotlin.String? = builder.pageId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AcceptPageRequest(")
        append("acceptCode=$acceptCode,")
        append("acceptCodeValidation=$acceptCodeValidation,")
        append("acceptType=$acceptType,")
        append("contactChannelId=$contactChannelId,")
        append("note=$note,")
        append("pageId=$pageId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptCode?.hashCode() ?: 0
        result = 31 * result + (acceptCodeValidation?.hashCode() ?: 0)
        result = 31 * result + (acceptType?.hashCode() ?: 0)
        result = 31 * result + (contactChannelId?.hashCode() ?: 0)
        result = 31 * result + (note?.hashCode() ?: 0)
        result = 31 * result + (pageId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AcceptPageRequest

        if (acceptCode != other.acceptCode) return false
        if (acceptCodeValidation != other.acceptCodeValidation) return false
        if (acceptType != other.acceptType) return false
        if (contactChannelId != other.contactChannelId) return false
        if (note != other.note) return false
        if (pageId != other.pageId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The accept code is a 6-digit code used to acknowledge the page.
         */
        var acceptCode: kotlin.String? = null
        /**
         * An optional field that Incident Manager uses to ENFORCE
         * AcceptCode validation when acknowledging an page. Acknowledgement can occur by
         * replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode
         * validation causes Incident Manager to verify that the code entered by the user matches the
         * code sent by Incident Manager with the page.
         * Incident Manager can also IGNORE
         * AcceptCode validation. Ignoring AcceptCode validation causes
         * Incident Manager to accept any value entered for the AcceptCode.
         */
        var acceptCodeValidation: aws.sdk.kotlin.services.ssmcontacts.model.AcceptCodeValidation? = null
        /**
         * The type indicates if the page was DELIVERED or READ.
         */
        var acceptType: aws.sdk.kotlin.services.ssmcontacts.model.AcceptType? = null
        /**
         * The ARN of the contact channel.
         */
        var contactChannelId: kotlin.String? = null
        /**
         * Information provided by the user when the user acknowledges the page.
         */
        var note: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the engagement to a contact channel.
         */
        var pageId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageRequest) : this() {
            this.acceptCode = x.acceptCode
            this.acceptCodeValidation = x.acceptCodeValidation
            this.acceptType = x.acceptType
            this.contactChannelId = x.contactChannelId
            this.note = x.note
            this.pageId = x.pageId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageRequest = AcceptPageRequest(this)
    }
}
