// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Records events during an engagement.
 */
class Receipt private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
     */
    val contactChannelArn: String? = builder.contactChannelArn
    /**
     * Information provided during the page acknowledgement.
     */
    val receiptInfo: String? = builder.receiptInfo
    /**
     * The time receipt was SENT, DELIVERED, or
     * READ.
     */
    val receiptTime: Instant? = builder.receiptTime
    /**
     * The type follows the engagement cycle, SENT, DELIVERED, and
     * READ.
     */
    val receiptType: ReceiptType? = builder.receiptType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Receipt = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Receipt(")
        append("contactChannelArn=$contactChannelArn,")
        append("receiptInfo=$receiptInfo,")
        append("receiptTime=$receiptTime,")
        append("receiptType=$receiptType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactChannelArn?.hashCode() ?: 0
        result = 31 * result + (receiptInfo?.hashCode() ?: 0)
        result = 31 * result + (receiptTime?.hashCode() ?: 0)
        result = 31 * result + (receiptType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Receipt

        if (contactChannelArn != other.contactChannelArn) return false
        if (receiptInfo != other.receiptInfo) return false
        if (receiptTime != other.receiptTime) return false
        if (receiptType != other.receiptType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Receipt = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Receipt
        /**
         * The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
         */
        fun contactChannelArn(contactChannelArn: String): FluentBuilder
        /**
         * Information provided during the page acknowledgement.
         */
        fun receiptInfo(receiptInfo: String): FluentBuilder
        /**
         * The time receipt was SENT, DELIVERED, or
         * READ.
         */
        fun receiptTime(receiptTime: Instant): FluentBuilder
        /**
         * The type follows the engagement cycle, SENT, DELIVERED, and
         * READ.
         */
        fun receiptType(receiptType: ReceiptType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
         */
        var contactChannelArn: String?
        /**
         * Information provided during the page acknowledgement.
         */
        var receiptInfo: String?
        /**
         * The time receipt was SENT, DELIVERED, or
         * READ.
         */
        var receiptTime: Instant?
        /**
         * The type follows the engagement cycle, SENT, DELIVERED, and
         * READ.
         */
        var receiptType: ReceiptType?

        fun build(): Receipt
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contactChannelArn: String? = null
        override var receiptInfo: String? = null
        override var receiptTime: Instant? = null
        override var receiptType: ReceiptType? = null

        constructor(x: Receipt) : this() {
            this.contactChannelArn = x.contactChannelArn
            this.receiptInfo = x.receiptInfo
            this.receiptTime = x.receiptTime
            this.receiptType = x.receiptType
        }

        override fun build(): Receipt = Receipt(this)
        override fun contactChannelArn(contactChannelArn: String): FluentBuilder = apply { this.contactChannelArn = contactChannelArn }
        override fun receiptInfo(receiptInfo: String): FluentBuilder = apply { this.receiptInfo = receiptInfo }
        override fun receiptTime(receiptTime: Instant): FluentBuilder = apply { this.receiptTime = receiptTime }
        override fun receiptType(receiptType: ReceiptType): FluentBuilder = apply { this.receiptType = receiptType }
    }
}
