// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Incident Manager engaging a contact's contact channel.
 */
class Page private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the contact that Incident Manager is engaging.
     */
    val contactArn: String? = builder.contactArn
    /**
     * The time the message was delivered to the contact channel.
     */
    val deliveryTime: Instant? = builder.deliveryTime
    /**
     * The ARN of the engagement that this page is part of.
     */
    val engagementArn: String? = builder.engagementArn
    /**
     * The ARN of the incident that's engaging the contact channel.
     */
    val incidentId: String? = builder.incidentId
    /**
     * The Amazon Resource Name (ARN) of the page to the contact channel.
     */
    val pageArn: String? = builder.pageArn
    /**
     * The time that the contact channel acknowledged engagement.
     */
    val readTime: Instant? = builder.readTime
    /**
     * The user that started the engagement.
     */
    val sender: String? = builder.sender
    /**
     * The time that Incident Manager engaged the contact channel.
     */
    val sentTime: Instant? = builder.sentTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Page = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Page(")
        append("contactArn=$contactArn,")
        append("deliveryTime=$deliveryTime,")
        append("engagementArn=$engagementArn,")
        append("incidentId=$incidentId,")
        append("pageArn=$pageArn,")
        append("readTime=$readTime,")
        append("sender=$sender,")
        append("sentTime=$sentTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactArn?.hashCode() ?: 0
        result = 31 * result + (deliveryTime?.hashCode() ?: 0)
        result = 31 * result + (engagementArn?.hashCode() ?: 0)
        result = 31 * result + (incidentId?.hashCode() ?: 0)
        result = 31 * result + (pageArn?.hashCode() ?: 0)
        result = 31 * result + (readTime?.hashCode() ?: 0)
        result = 31 * result + (sender?.hashCode() ?: 0)
        result = 31 * result + (sentTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Page

        if (contactArn != other.contactArn) return false
        if (deliveryTime != other.deliveryTime) return false
        if (engagementArn != other.engagementArn) return false
        if (incidentId != other.incidentId) return false
        if (pageArn != other.pageArn) return false
        if (readTime != other.readTime) return false
        if (sender != other.sender) return false
        if (sentTime != other.sentTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Page = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Page
        /**
         * The ARN of the contact that Incident Manager is engaging.
         */
        fun contactArn(contactArn: String): FluentBuilder
        /**
         * The time the message was delivered to the contact channel.
         */
        fun deliveryTime(deliveryTime: Instant): FluentBuilder
        /**
         * The ARN of the engagement that this page is part of.
         */
        fun engagementArn(engagementArn: String): FluentBuilder
        /**
         * The ARN of the incident that's engaging the contact channel.
         */
        fun incidentId(incidentId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the page to the contact channel.
         */
        fun pageArn(pageArn: String): FluentBuilder
        /**
         * The time that the contact channel acknowledged engagement.
         */
        fun readTime(readTime: Instant): FluentBuilder
        /**
         * The user that started the engagement.
         */
        fun sender(sender: String): FluentBuilder
        /**
         * The time that Incident Manager engaged the contact channel.
         */
        fun sentTime(sentTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the contact that Incident Manager is engaging.
         */
        var contactArn: String?
        /**
         * The time the message was delivered to the contact channel.
         */
        var deliveryTime: Instant?
        /**
         * The ARN of the engagement that this page is part of.
         */
        var engagementArn: String?
        /**
         * The ARN of the incident that's engaging the contact channel.
         */
        var incidentId: String?
        /**
         * The Amazon Resource Name (ARN) of the page to the contact channel.
         */
        var pageArn: String?
        /**
         * The time that the contact channel acknowledged engagement.
         */
        var readTime: Instant?
        /**
         * The user that started the engagement.
         */
        var sender: String?
        /**
         * The time that Incident Manager engaged the contact channel.
         */
        var sentTime: Instant?

        fun build(): Page
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contactArn: String? = null
        override var deliveryTime: Instant? = null
        override var engagementArn: String? = null
        override var incidentId: String? = null
        override var pageArn: String? = null
        override var readTime: Instant? = null
        override var sender: String? = null
        override var sentTime: Instant? = null

        constructor(x: Page) : this() {
            this.contactArn = x.contactArn
            this.deliveryTime = x.deliveryTime
            this.engagementArn = x.engagementArn
            this.incidentId = x.incidentId
            this.pageArn = x.pageArn
            this.readTime = x.readTime
            this.sender = x.sender
            this.sentTime = x.sentTime
        }

        override fun build(): Page = Page(this)
        override fun contactArn(contactArn: String): FluentBuilder = apply { this.contactArn = contactArn }
        override fun deliveryTime(deliveryTime: Instant): FluentBuilder = apply { this.deliveryTime = deliveryTime }
        override fun engagementArn(engagementArn: String): FluentBuilder = apply { this.engagementArn = engagementArn }
        override fun incidentId(incidentId: String): FluentBuilder = apply { this.incidentId = incidentId }
        override fun pageArn(pageArn: String): FluentBuilder = apply { this.pageArn = pageArn }
        override fun readTime(readTime: Instant): FluentBuilder = apply { this.readTime = readTime }
        override fun sender(sender: String): FluentBuilder = apply { this.sender = sender }
        override fun sentTime(sentTime: Instant): FluentBuilder = apply { this.sentTime = sentTime }
    }
}
