// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model



class ListEngagementsRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the incident you're listing engagements for.
     */
    val incidentId: String? = builder.incidentId
    /**
     * The maximum number of engagements per page of results.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The pagination token to continue to the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The time range to lists engagements for an incident.
     */
    val timeRangeValue: TimeRange? = builder.timeRangeValue

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListEngagementsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListEngagementsRequest(")
        append("incidentId=$incidentId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("timeRangeValue=$timeRangeValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = incidentId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (timeRangeValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListEngagementsRequest

        if (incidentId != other.incidentId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (timeRangeValue != other.timeRangeValue) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListEngagementsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListEngagementsRequest
        /**
         * The Amazon Resource Name (ARN) of the incident you're listing engagements for.
         */
        fun incidentId(incidentId: String): FluentBuilder
        /**
         * The maximum number of engagements per page of results.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The pagination token to continue to the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The time range to lists engagements for an incident.
         */
        fun timeRangeValue(timeRangeValue: TimeRange): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the incident you're listing engagements for.
         */
        var incidentId: String?
        /**
         * The maximum number of engagements per page of results.
         */
        var maxResults: Int?
        /**
         * The pagination token to continue to the next page of results.
         */
        var nextToken: String?
        /**
         * The time range to lists engagements for an incident.
         */
        var timeRangeValue: TimeRange?

        fun build(): ListEngagementsRequest
        /**
         * construct an [aws.sdk.kotlin.services.ssmcontacts.model.TimeRange] inside the given [block]
         */
        fun timeRangeValue(block: TimeRange.DslBuilder.() -> kotlin.Unit) {
            this.timeRangeValue = TimeRange.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var incidentId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var timeRangeValue: TimeRange? = null

        constructor(x: ListEngagementsRequest) : this() {
            this.incidentId = x.incidentId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.timeRangeValue = x.timeRangeValue
        }

        override fun build(): ListEngagementsRequest = ListEngagementsRequest(this)
        override fun incidentId(incidentId: String): FluentBuilder = apply { this.incidentId = incidentId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun timeRangeValue(timeRangeValue: TimeRange): FluentBuilder = apply { this.timeRangeValue = timeRangeValue }
    }
}
