// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Incident Manager reaching out to a contact or escalation plan to engage contact during an
 * incident.
 */
class Engagement private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the escalation plan or contact that Incident Manager is engaging.
     */
    val contactArn: String? = builder.contactArn
    /**
     * The Amazon Resource Name (ARN) of the engagement.
     */
    val engagementArn: String? = builder.engagementArn
    /**
     * The ARN of the incident that's engaging the contact.
     */
    val incidentId: String? = builder.incidentId
    /**
     * The user that started the engagement.
     */
    val sender: String? = builder.sender
    /**
     * The time that the engagement began.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The time that the engagement ended.
     */
    val stopTime: Instant? = builder.stopTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Engagement = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Engagement(")
        append("contactArn=$contactArn,")
        append("engagementArn=$engagementArn,")
        append("incidentId=$incidentId,")
        append("sender=$sender,")
        append("startTime=$startTime,")
        append("stopTime=$stopTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactArn?.hashCode() ?: 0
        result = 31 * result + (engagementArn?.hashCode() ?: 0)
        result = 31 * result + (incidentId?.hashCode() ?: 0)
        result = 31 * result + (sender?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (stopTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Engagement

        if (contactArn != other.contactArn) return false
        if (engagementArn != other.engagementArn) return false
        if (incidentId != other.incidentId) return false
        if (sender != other.sender) return false
        if (startTime != other.startTime) return false
        if (stopTime != other.stopTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Engagement = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Engagement
        /**
         * The ARN of the escalation plan or contact that Incident Manager is engaging.
         */
        fun contactArn(contactArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the engagement.
         */
        fun engagementArn(engagementArn: String): FluentBuilder
        /**
         * The ARN of the incident that's engaging the contact.
         */
        fun incidentId(incidentId: String): FluentBuilder
        /**
         * The user that started the engagement.
         */
        fun sender(sender: String): FluentBuilder
        /**
         * The time that the engagement began.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The time that the engagement ended.
         */
        fun stopTime(stopTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the escalation plan or contact that Incident Manager is engaging.
         */
        var contactArn: String?
        /**
         * The Amazon Resource Name (ARN) of the engagement.
         */
        var engagementArn: String?
        /**
         * The ARN of the incident that's engaging the contact.
         */
        var incidentId: String?
        /**
         * The user that started the engagement.
         */
        var sender: String?
        /**
         * The time that the engagement began.
         */
        var startTime: Instant?
        /**
         * The time that the engagement ended.
         */
        var stopTime: Instant?

        fun build(): Engagement
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contactArn: String? = null
        override var engagementArn: String? = null
        override var incidentId: String? = null
        override var sender: String? = null
        override var startTime: Instant? = null
        override var stopTime: Instant? = null

        constructor(x: Engagement) : this() {
            this.contactArn = x.contactArn
            this.engagementArn = x.engagementArn
            this.incidentId = x.incidentId
            this.sender = x.sender
            this.startTime = x.startTime
            this.stopTime = x.stopTime
        }

        override fun build(): Engagement = Engagement(this)
        override fun contactArn(contactArn: String): FluentBuilder = apply { this.contactArn = contactArn }
        override fun engagementArn(engagementArn: String): FluentBuilder = apply { this.engagementArn = engagementArn }
        override fun incidentId(incidentId: String): FluentBuilder = apply { this.incidentId = incidentId }
        override fun sender(sender: String): FluentBuilder = apply { this.sender = sender }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun stopTime(stopTime: Instant): FluentBuilder = apply { this.stopTime = stopTime }
    }
}
