// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model



class CreateContactChannelRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
     */
    val contactId: String? = builder.contactId
    /**
     * If you want to activate the channel at a later time, you can choose to defer activation.
     * Incident Manager can't engage your contact channel until it has been activated.
     */
    val deferActivation: Boolean? = builder.deferActivation
    /**
     * The details that Incident Manager uses when trying to engage the contact channel. The format
     * is dependent on the type of the contact channel. The following are the expected
     * formats:
     * SMS - '+' followed by the country code and phone number
     * VOICE - '+' followed by the country code and phone number
     * EMAIL - any standard email format
     */
    val deliveryAddress: ContactChannelAddress? = builder.deliveryAddress
    /**
     * A token ensuring that the operation is called only once with the specified
     * details.
     */
    val idempotencyToken: String? = builder.idempotencyToken
    /**
     * The name of the contact channel.
     */
    val name: String? = builder.name
    /**
     * Incident Manager supports three types of contact channels:
     * SMS
     * VOICE
     * EMAIL
     */
    val type: ChannelType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateContactChannelRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContactChannelRequest(")
        append("contactId=$contactId,")
        append("deferActivation=$deferActivation,")
        append("deliveryAddress=$deliveryAddress,")
        append("idempotencyToken=$idempotencyToken,")
        append("name=$name,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactId?.hashCode() ?: 0
        result = 31 * result + (deferActivation?.hashCode() ?: 0)
        result = 31 * result + (deliveryAddress?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateContactChannelRequest

        if (contactId != other.contactId) return false
        if (deferActivation != other.deferActivation) return false
        if (deliveryAddress != other.deliveryAddress) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateContactChannelRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateContactChannelRequest
        /**
         * The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
         */
        fun contactId(contactId: String): FluentBuilder
        /**
         * If you want to activate the channel at a later time, you can choose to defer activation.
         * Incident Manager can't engage your contact channel until it has been activated.
         */
        fun deferActivation(deferActivation: Boolean): FluentBuilder
        /**
         * The details that Incident Manager uses when trying to engage the contact channel. The format
         * is dependent on the type of the contact channel. The following are the expected
         * formats:
         * SMS - '+' followed by the country code and phone number
         * VOICE - '+' followed by the country code and phone number
         * EMAIL - any standard email format
         */
        fun deliveryAddress(deliveryAddress: ContactChannelAddress): FluentBuilder
        /**
         * A token ensuring that the operation is called only once with the specified
         * details.
         */
        fun idempotencyToken(idempotencyToken: String): FluentBuilder
        /**
         * The name of the contact channel.
         */
        fun name(name: String): FluentBuilder
        /**
         * Incident Manager supports three types of contact channels:
         * SMS
         * VOICE
         * EMAIL
         */
        fun type(type: ChannelType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
         */
        var contactId: String?
        /**
         * If you want to activate the channel at a later time, you can choose to defer activation.
         * Incident Manager can't engage your contact channel until it has been activated.
         */
        var deferActivation: Boolean?
        /**
         * The details that Incident Manager uses when trying to engage the contact channel. The format
         * is dependent on the type of the contact channel. The following are the expected
         * formats:
         * SMS - '+' followed by the country code and phone number
         * VOICE - '+' followed by the country code and phone number
         * EMAIL - any standard email format
         */
        var deliveryAddress: ContactChannelAddress?
        /**
         * A token ensuring that the operation is called only once with the specified
         * details.
         */
        var idempotencyToken: String?
        /**
         * The name of the contact channel.
         */
        var name: String?
        /**
         * Incident Manager supports three types of contact channels:
         * SMS
         * VOICE
         * EMAIL
         */
        var type: ChannelType?

        fun build(): CreateContactChannelRequest
        /**
         * construct an [aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress] inside the given [block]
         */
        fun deliveryAddress(block: ContactChannelAddress.DslBuilder.() -> kotlin.Unit) {
            this.deliveryAddress = ContactChannelAddress.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contactId: String? = null
        override var deferActivation: Boolean? = null
        override var deliveryAddress: ContactChannelAddress? = null
        override var idempotencyToken: String? = null
        override var name: String? = null
        override var type: ChannelType? = null

        constructor(x: CreateContactChannelRequest) : this() {
            this.contactId = x.contactId
            this.deferActivation = x.deferActivation
            this.deliveryAddress = x.deliveryAddress
            this.idempotencyToken = x.idempotencyToken
            this.name = x.name
            this.type = x.type
        }

        override fun build(): CreateContactChannelRequest = CreateContactChannelRequest(this)
        override fun contactId(contactId: String): FluentBuilder = apply { this.contactId = contactId }
        override fun deferActivation(deferActivation: Boolean): FluentBuilder = apply { this.deferActivation = deferActivation }
        override fun deliveryAddress(deliveryAddress: ContactChannelAddress): FluentBuilder = apply { this.deliveryAddress = deliveryAddress }
        override fun idempotencyToken(idempotencyToken: String): FluentBuilder = apply { this.idempotencyToken = idempotencyToken }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun type(type: ChannelType): FluentBuilder = apply { this.type = type }
    }
}
