// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model



/**
 * The method that Incident Manager uses to engage a contact.
 */
class ContactChannel private constructor(builder: BuilderImpl) {
    /**
     * A Boolean value describing if the contact channel has been activated or not. If the
     * contact channel isn't activated, Incident Manager can't engage the contact through it.
     */
    val activationStatus: ActivationStatus? = builder.activationStatus
    /**
     * The ARN of the contact that contains the contact channel.
     */
    val contactArn: String? = builder.contactArn
    /**
     * The Amazon Resource Name (ARN) of the contact channel.
     */
    val contactChannelArn: String? = builder.contactChannelArn
    /**
     * The details that Incident Manager uses when trying to engage the contact channel.
     */
    val deliveryAddress: ContactChannelAddress? = builder.deliveryAddress
    /**
     * The name of the contact channel.
     */
    val name: String? = builder.name
    /**
     * The type of the contact channel. Incident Manager supports three contact methods:
     * SMS
     * VOICE
     * EMAIL
     */
    val type: ChannelType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ContactChannel = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ContactChannel(")
        append("activationStatus=$activationStatus,")
        append("contactArn=$contactArn,")
        append("contactChannelArn=$contactChannelArn,")
        append("deliveryAddress=$deliveryAddress,")
        append("name=$name,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationStatus?.hashCode() ?: 0
        result = 31 * result + (contactArn?.hashCode() ?: 0)
        result = 31 * result + (contactChannelArn?.hashCode() ?: 0)
        result = 31 * result + (deliveryAddress?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ContactChannel

        if (activationStatus != other.activationStatus) return false
        if (contactArn != other.contactArn) return false
        if (contactChannelArn != other.contactChannelArn) return false
        if (deliveryAddress != other.deliveryAddress) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ContactChannel = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ContactChannel
        /**
         * A Boolean value describing if the contact channel has been activated or not. If the
         * contact channel isn't activated, Incident Manager can't engage the contact through it.
         */
        fun activationStatus(activationStatus: ActivationStatus): FluentBuilder
        /**
         * The ARN of the contact that contains the contact channel.
         */
        fun contactArn(contactArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the contact channel.
         */
        fun contactChannelArn(contactChannelArn: String): FluentBuilder
        /**
         * The details that Incident Manager uses when trying to engage the contact channel.
         */
        fun deliveryAddress(deliveryAddress: ContactChannelAddress): FluentBuilder
        /**
         * The name of the contact channel.
         */
        fun name(name: String): FluentBuilder
        /**
         * The type of the contact channel. Incident Manager supports three contact methods:
         * SMS
         * VOICE
         * EMAIL
         */
        fun type(type: ChannelType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A Boolean value describing if the contact channel has been activated or not. If the
         * contact channel isn't activated, Incident Manager can't engage the contact through it.
         */
        var activationStatus: ActivationStatus?
        /**
         * The ARN of the contact that contains the contact channel.
         */
        var contactArn: String?
        /**
         * The Amazon Resource Name (ARN) of the contact channel.
         */
        var contactChannelArn: String?
        /**
         * The details that Incident Manager uses when trying to engage the contact channel.
         */
        var deliveryAddress: ContactChannelAddress?
        /**
         * The name of the contact channel.
         */
        var name: String?
        /**
         * The type of the contact channel. Incident Manager supports three contact methods:
         * SMS
         * VOICE
         * EMAIL
         */
        var type: ChannelType?

        fun build(): ContactChannel
        /**
         * construct an [aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress] inside the given [block]
         */
        fun deliveryAddress(block: ContactChannelAddress.DslBuilder.() -> kotlin.Unit) {
            this.deliveryAddress = ContactChannelAddress.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activationStatus: ActivationStatus? = null
        override var contactArn: String? = null
        override var contactChannelArn: String? = null
        override var deliveryAddress: ContactChannelAddress? = null
        override var name: String? = null
        override var type: ChannelType? = null

        constructor(x: ContactChannel) : this() {
            this.activationStatus = x.activationStatus
            this.contactArn = x.contactArn
            this.contactChannelArn = x.contactChannelArn
            this.deliveryAddress = x.deliveryAddress
            this.name = x.name
            this.type = x.type
        }

        override fun build(): ContactChannel = ContactChannel(this)
        override fun activationStatus(activationStatus: ActivationStatus): FluentBuilder = apply { this.activationStatus = activationStatus }
        override fun contactArn(contactArn: String): FluentBuilder = apply { this.contactArn = contactArn }
        override fun contactChannelArn(contactChannelArn: String): FluentBuilder = apply { this.contactChannelArn = contactChannelArn }
        override fun deliveryAddress(deliveryAddress: ContactChannelAddress): FluentBuilder = apply { this.deliveryAddress = deliveryAddress }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun type(type: ChannelType): FluentBuilder = apply { this.type = type }
    }
}
