// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model



/**
 * A personal contact or escalation plan that Incident Manager engages during an
 * incident.
 */
class Contact private constructor(builder: BuilderImpl) {
    /**
     * The unique and identifiable alias of the contact or escalation plan.
     */
    val alias: String? = builder.alias
    /**
     * The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    val contactArn: String? = builder.contactArn
    /**
     * The full name of the contact or escalation plan.
     */
    val displayName: String? = builder.displayName
    /**
     * Refers to the type of contact. A single contact is type PERSONAL and an
     * escalation plan is type ESCALATION.
     */
    val type: ContactType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Contact = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Contact(")
        append("alias=$alias,")
        append("contactArn=$contactArn,")
        append("displayName=$displayName,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (contactArn?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Contact

        if (alias != other.alias) return false
        if (contactArn != other.contactArn) return false
        if (displayName != other.displayName) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Contact = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Contact
        /**
         * The unique and identifiable alias of the contact or escalation plan.
         */
        fun alias(alias: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the contact or escalation plan.
         */
        fun contactArn(contactArn: String): FluentBuilder
        /**
         * The full name of the contact or escalation plan.
         */
        fun displayName(displayName: String): FluentBuilder
        /**
         * Refers to the type of contact. A single contact is type PERSONAL and an
         * escalation plan is type ESCALATION.
         */
        fun type(type: ContactType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The unique and identifiable alias of the contact or escalation plan.
         */
        var alias: String?
        /**
         * The Amazon Resource Name (ARN) of the contact or escalation plan.
         */
        var contactArn: String?
        /**
         * The full name of the contact or escalation plan.
         */
        var displayName: String?
        /**
         * Refers to the type of contact. A single contact is type PERSONAL and an
         * escalation plan is type ESCALATION.
         */
        var type: ContactType?

        fun build(): Contact
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var alias: String? = null
        override var contactArn: String? = null
        override var displayName: String? = null
        override var type: ContactType? = null

        constructor(x: Contact) : this() {
            this.alias = x.alias
            this.contactArn = x.contactArn
            this.displayName = x.displayName
            this.type = x.type
        }

        override fun build(): Contact = Contact(this)
        override fun alias(alias: String): FluentBuilder = apply { this.alias = alias }
        override fun contactArn(contactArn: String): FluentBuilder = apply { this.contactArn = contactArn }
        override fun displayName(displayName: String): FluentBuilder = apply { this.displayName = displayName }
        override fun type(type: ContactType): FluentBuilder = apply { this.type = type }
    }
}
