// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model



/**
 * Information about the contact channel that Incident Manager uses to engage the
 * contact.
 */
class ChannelTargetInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the contact channel.
     */
    val contactChannelId: String? = builder.contactChannelId
    /**
     * The number of minutes to wait to retry sending engagement in the case the engagement
     * initially fails.
     */
    val retryIntervalInMinutes: Int? = builder.retryIntervalInMinutes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ChannelTargetInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelTargetInfo(")
        append("contactChannelId=$contactChannelId,")
        append("retryIntervalInMinutes=$retryIntervalInMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactChannelId?.hashCode() ?: 0
        result = 31 * result + (retryIntervalInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ChannelTargetInfo

        if (contactChannelId != other.contactChannelId) return false
        if (retryIntervalInMinutes != other.retryIntervalInMinutes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ChannelTargetInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ChannelTargetInfo
        /**
         * The Amazon Resource Name (ARN) of the contact channel.
         */
        fun contactChannelId(contactChannelId: String): FluentBuilder
        /**
         * The number of minutes to wait to retry sending engagement in the case the engagement
         * initially fails.
         */
        fun retryIntervalInMinutes(retryIntervalInMinutes: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the contact channel.
         */
        var contactChannelId: String?
        /**
         * The number of minutes to wait to retry sending engagement in the case the engagement
         * initially fails.
         */
        var retryIntervalInMinutes: Int?

        fun build(): ChannelTargetInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var contactChannelId: String? = null
        override var retryIntervalInMinutes: Int? = null

        constructor(x: ChannelTargetInfo) : this() {
            this.contactChannelId = x.contactChannelId
            this.retryIntervalInMinutes = x.retryIntervalInMinutes
        }

        override fun build(): ChannelTargetInfo = ChannelTargetInfo(this)
        override fun contactChannelId(contactChannelId: String): FluentBuilder = apply { this.contactChannelId = contactChannelId }
        override fun retryIntervalInMinutes(retryIntervalInMinutes: Int): FluentBuilder = apply { this.retryIntervalInMinutes = retryIntervalInMinutes }
    }
}
